<?php

use CodenericProductPhotoAI\Core\Api;
use CodenericProductPhotoAI\Admin\Menu;
use CodenericProductPhotoAI\Core\WooCommerce;
use CodenericProductPhotoAI\Core\Settings;
use CodenericProductPhotoAI\Assets\Frontend;
use CodenericProductPhotoAI\Assets\Admin;
use CodenericProductPhotoAI\Traits\Base;

defined('ABSPATH') || exit;

/**
 * Class CodenericProductPhotoAI
 *
 * The main class for the Product Photo AI plugin, responsible for initialization and setup.
 *
 * @since 1.0.0
 */
final class CodenericProductPhotoAI
{

	use Base;

	/**
	 * Class constructor to set up constants for the plugin.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function __construct()
	{
		// Plugin constants are now defined in the main plugin file
	}

	/**
	 * Main execution point where the plugin will fire up.
	 *
	 * Initializes necessary components for both admin and frontend.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function init()
	{
		if (is_admin()) {
			Menu::get_instance()->init();
			Admin::get_instance()->bootstrap();
		}

		// Initialze core functionalities.
		Frontend::get_instance()->bootstrap();
		API::get_instance()->init();
		WooCommerce::get_instance()->init();
		Settings::get_instance()->init();

		add_action('init', array($this, 'i18n'));
		add_action('init', array($this, 'register_blocks'));
	}

	public function register_blocks()
	{
		register_block_type(plugin_dir_path(__FILE__) . 'assets/blocks/block-1');
	}

	/**
	 * Internationalization setup for language translations.
	 *
	 * Note: load_plugin_textdomain() is not needed for WordPress.org plugins since WordPress 4.6.
	 * WordPress automatically loads translations for plugins hosted on WordPress.org.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function i18n()
	{
		// load_plugin_textdomain() removed as it's not needed for WordPress.org plugins
	}
}
