<?php

/**
 * Plugin Function file.
 *
 * @since 1.0.0
 *
 * @package ProductPhotoAI
 */

defined('ABSPATH') || exit;

/**
 * Retrieves the configuration from the specified file.
 *
 * @param string $config_file_name The name of the configuration file.
 * @return array
 *
 * @since 1.0.0
 */
function cppai_get_config($config_file_name)
{
	// Use plugin_dir_path() relative to this file to get to the plugin root, then to config
	$plugin_root = dirname(plugin_dir_path(__FILE__));
	$config_file_path = $plugin_root . '/config/' . $config_file_name . '.php';
	if (file_exists($config_file_path)) {
		return require $config_file_path;
	}
	return array();
}
