<?php

/**
 * ProductPhotoAI Routes
 *
 * Defines and registers custom API routes for the ProductPhotoAI using the Haruncpi\WpApi library.
 *
 * @package ProductPhotoAI\Routes
 */

namespace CodenericProductPhotoAI\Routes;

use CodenericProductPhotoAI\Libs\API\Route;

// Define permission callback functions
function edit_posts_permission() {
	return current_user_can('edit_posts');
}

Route::prefix(
	CPPAI_ROUTE_PREFIX,
	function (Route $route) {

		// PhotoAI routes for WooCommerce integration with proper permissions
		$route->post('/photoai/generate', '\CodenericProductPhotoAI\Controllers\PhotoAI\Actions@generate_product_photos', '\CodenericProductPhotoAI\Routes\edit_posts_permission');
		$route->get('/photoai/status/{product_id}', '\CodenericProductPhotoAI\Controllers\PhotoAI\Actions@check_photo_status', '\CodenericProductPhotoAI\Routes\edit_posts_permission');

	}
);
