<?php

namespace CodenericProductPhotoAI\Core;

use CodenericProductPhotoAI\Traits\Base;
use CodenericProductPhotoAI\Libs\API\Config;

/**
 * Class API
 *
 * Initializes and configures the API for the ProductPhotoAI.
 *
 * @package ProductPhotoAI\Core
 */
class API
{

	use Base;

	/**
	 * Initializes the API for the ProductPhotoAI.
	 *
	 * @return void
	 */
	public function init()
	{
		Config::set_route_file(CPPAI_DIR . '/includes/Routes/Api.php')
			->set_namespace('CodenericProductPhotoAI\Api')
			->init();
	}
}
