<?php

namespace CodenericProductPhotoAI\Admin;

use CodenericProductPhotoAI\Traits\Base;

/**
 * Class Menu
 *
 * Represents the admin menu management for the ProductPhotoAI plugin.
 *
 * @package ProductPhotoAI\Admin
 */
class Menu
{

	use Base;

	/**
	 * Parent slug for the menu.
	 *
	 * @var string
	 */
	private $parent_slug = 'cppai-menu';

	/**
	 * Initializes the admin menu.
	 *
	 * @return void
	 */
	public function init()
	{
		// Hook the function to the admin menu.
		add_action('admin_menu', array($this, 'menu'));
	}

	/**
	 * Adds a menu to the WordPress admin dashboard.
	 *
	 * @return void
	 */
	public function menu()
	{

		add_menu_page(
			__('Product Photo AI', 'product-photo-ai-for-woocommerce'),
			__('Product Photo AI', 'product-photo-ai-for-woocommerce'),
			'manage_options',
			$this->parent_slug,
			array($this, 'admin_page'),
			'dashicons-camera',
			56
		);

		$plugin_url = admin_url('/admin.php?page=' . $this->parent_slug);

		$current_page = get_admin_page_parent();

		if ($current_page === $this->parent_slug) {
			$plugin_url = '';
		}

		// $submenu_pages = array(
		// 	array(
		// 		'parent_slug' => $this->parent_slug,
		// 		'page_title'  => __( 'Dashboard', 'product-photo-ai-for-woocommerce' ),
		// 		'menu_title'  => __( 'Dashboard', 'product-photo-ai-for-woocommerce' ),
		// 		'capability'  => 'manage_options',
		// 		'menu_slug'   => $this->parent_slug,
		// 		'function'    => array( $this, 'admin_page' ), // Uses the same callback function as parent menu.
		// 	),
		// 	array(
		// 		'parent_slug' => $this->parent_slug,
		// 		'page_title'  => __( 'Settings', 'product-photo-ai-for-woocommerce' ),
		// 		'menu_title'  => __( 'Settings', 'product-photo-ai-for-woocommerce' ),
		// 		'capability'  => 'manage_options',
		// 		'menu_slug'   => $plugin_url . '/#/settings',
		// 		'function'    => null, // Uses the same callback function as parent menu.
		// 	),
		// );

		// $plugin_submenu_pages = apply_filters( 'psai_submenu_pages', $submenu_pages );

		// foreach ( $plugin_submenu_pages as $submenu ) {

		// 	add_submenu_page(
		// 		$submenu['parent_slug'],
		// 		$submenu['page_title'],
		// 		$submenu['menu_title'],
		// 		$submenu['capability'],
		// 		$submenu['menu_slug'],
		// 		$submenu['function']
		// 	);
		// }
	}

	/**
	 * Callback function for the main "Product Photo AI" menu page.
	 *
	 * @return void
	 */
	public function admin_page()
	{
?>
		<div id="cppai-admin" class="cppai-app">
			<div class="wrap">
				<h1><?php esc_html_e('Product Photo AI for WooCommerce', 'product-photo-ai-for-woocommerce'); ?></h1>
				<div class="product-photo-ai-for-woocommerce-dashboard">
					
					<div class="getting-started-section">
						<h3><?php esc_html_e('Getting Started', 'product-photo-ai-for-woocommerce'); ?></h3>
						<p><?php esc_html_e('Follow these steps to start generating professional product photos:', 'product-photo-ai-for-woocommerce'); ?></p>
						<ol>
							<li><?php echo wp_kses_post(__('Visit <a href="https://product-photo-ai.com" target="_blank">product-photo-ai.com</a> to sign up for a free trial or paid plan', 'product-photo-ai-for-woocommerce')); ?></li>
							<li><?php esc_html_e('Copy your API key from your account dashboard', 'product-photo-ai-for-woocommerce'); ?></li>
							<li><?php esc_html_e('Go to Product Photo AI → Settings in your WordPress admin and paste your API key', 'product-photo-ai-for-woocommerce'); ?></li>
							<li><?php esc_html_e('Navigate to (WooCommerce) Products → All Products and edit any product', 'product-photo-ai-for-woocommerce'); ?></li>
							<li><?php esc_html_e('Look for the "Product Photo AI" meta box (bottom right) and click "Generate AI Photos..."', 'product-photo-ai-for-woocommerce'); ?></li>
							<li><?php esc_html_e('Upload an example image of the product to generate images automatically!', 'product-photo-ai-for-woocommerce'); ?></li>
							<li><?php esc_html_e('You can now select the generated images as usual from the media library.', 'product-photo-ai-for-woocommerce'); ?></li>
						</ol>
					</div>
					
					<div class="status-section">
						<h3><?php esc_html_e('System Status', 'product-photo-ai-for-woocommerce'); ?></h3>
						<?php 
						$settings = \CodenericProductPhotoAI\Core\Settings::get_instance();
						$api_key = $settings->get_setting('api_key', '');
						?>
						<div class="status-grid">
							<div class="status-item <?php echo esc_attr(!empty($api_key) ? 'status-ok' : 'status-error'); ?>">
                    <span class="status-icon"><?php echo esc_html(!empty($api_key) ? '✓' : '✗'); ?></span>
                    					<span><?php esc_html_e('API Key', 'product-photo-ai-for-woocommerce'); ?>:
						<?php echo !empty($api_key) ? esc_html__('Configured', 'product-photo-ai-for-woocommerce') : esc_html__('Not configured', 'product-photo-ai-for-woocommerce'); ?>
                    </span>
								<?php if (empty($api_key)): ?>
														<a href="<?php echo esc_url(admin_url('admin.php?page=cppai-settings')); ?>" class="button button-small">
						<?php esc_html_e('Configure', 'product-photo-ai-for-woocommerce'); ?>
									</a>
								<?php endif; ?>
							</div>
						</div>
					</div>
					

				</div>
			</div>
		</div>
<?php
	}
}
