<?php
/**
 * Plugin Name: Product Fees Toolkit for WooCommerce
 * Plugin URI: https://wordpress.org/plugins/product-fees-toolkit-for-woocommerce
 * Description: Add additional fees at checkout based on products that are in the cart.
 * Version: 1.0
 * Author: Riaan Knoetze
 * Author URI: https://profiles.wordpress.org/riaanknoetze/
 *
 * Text Domain: product-fees-toolkit-for-woocommerce
 * Domain Path: /languages/
 *
 * Requires at least: 6.0
 * Requires PHP: 7.4
 * Tested up to: 6.9
 * WC tested up to: 10.4.0
 * WC requires at least: 9.0
 * Requires Plugins: woocommerce
 *
 * License: GPL v3 or later
 * License URI: http://www.gnu.org/licenses/old-licenses/gpl-3.0.html
 *
 * @package ProductFeesToolkitForWooCommerce
 */

declare(strict_types=1);

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Constants.
 */
if ( ! defined( 'PFTFW_VERSION' ) ) {
	define( 'PFTFW_VERSION', '1.0' );
}
if ( ! defined( 'PFTFW_PLUGIN_FILE' ) ) {
	define( 'PFTFW_PLUGIN_FILE', __FILE__ );
}
if ( ! defined( 'PFTFW_PLUGIN_DIR' ) ) {
	define( 'PFTFW_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'PFTFW_PLUGIN_URL' ) ) {
	define( 'PFTFW_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

/**
 * Autoloader (plugin-scoped).
 *
 * Load our lightweight autoloader so classes are available during activation too.
 */
require_once PFTFW_PLUGIN_DIR . 'src/infrastructure/class-autoloader.php';
\PFTFW\Infrastructure\Autoloader::register();

/**
 * WooCommerce HPOS compatibility.
 */
add_action(
	'before_woocommerce_init',
	static function () {
		if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', PFTFW_PLUGIN_FILE, true );
		}
	}
);

/**
 * Plugin action links (Plugins screen).
 */
if ( ! function_exists( 'pftfw_settings_link_filter' ) ) {
	/**
	 * Prepend Settings link for this plugin.
	 *
	 * @param array $links Existing links.
	 * @return array
	 */
	function pftfw_settings_link_filter( array $links ): array { // phpcs:ignore Universal.NamingConventions.NoReservedKeywordParameterNames.linksFound
		$url = admin_url( 'admin.php?page=wc-settings&tab=products&section=fees' );
		array_unshift( $links, '<a href="' . esc_url( $url ) . '">' . esc_html__( 'Settings', 'product-fees-toolkit-for-woocommerce' ) . '</a>' );
		return $links;
	}
}

add_filter( 'plugin_action_links_' . plugin_basename( PFTFW_PLUGIN_FILE ), 'pftfw_settings_link_filter', 10, 1 );
add_filter( 'network_admin_plugin_action_links_' . plugin_basename( PFTFW_PLUGIN_FILE ), 'pftfw_settings_link_filter', 10, 1 );

/**
 * Activation checks and admin notices.
 */
require_once PFTFW_PLUGIN_DIR . 'src/infrastructure/class-activator.php';
register_activation_hook( __FILE__, array( \PFTFW\Infrastructure\Activator::class, 'activate' ) );

require_once PFTFW_PLUGIN_DIR . 'src/infrastructure/class-admin-notices.php';
\PFTFW\Infrastructure\Admin_Notices::register();

/**
 * Localization.
 *
 * WordPress 4.6+ auto-loads translations for WordPress.org hosted plugins.
 * No manual load_plugin_textdomain() call is required.
 */
add_action(
	'plugins_loaded',
	static function () {
		if ( ! class_exists( 'WooCommerce' ) ) {
			return;
		}

		$plugin = new \PFTFW\Plugin();
		$plugin->init();
	},
	20
);
