<?php
/**
 * Plugin Name: Product Attribute Icons Display
 * Plugin URI: https://wordpress.org/plugins/product-attribute-icons-display
 * Description: Display icons for product attributes on single product pages with customizable labels and icon classes.
 * Version: 1.0.0
 * Author: NeatPlugins.com
 * Author URI: https://neatplugins.com
 * Text Domain: product-attribute-icons-display
 * Domain Path: /languages
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * WC requires at least: 5.0
 * WC tested up to: 8.0
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Plugin version.
 */
define( 'PAIW_VERSION', '1.0.0' );

/**
 * Plugin directory path.
 */
define( 'PAIW_PATH', plugin_dir_path( __FILE__ ) );

/**
 * Plugin directory URL.
 */
define( 'PAIW_URL', plugin_dir_url( __FILE__ ) );

/**
 * Load the core class.
 */
require_once PAIW_PATH . 'includes/class-paiw-core.php';

/**
 * Declare WooCommerce feature compatibility.
 */
function paiw_declare_woocommerce_compatibility() {
	if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, true );
	}
}
add_action( 'before_woocommerce_init', 'paiw_declare_woocommerce_compatibility' );

/**
 * Initialize the plugin.
 */
function paiw_init() {
	return PAIW_Core::get_instance();
}

// Initialize on plugins_loaded to ensure WooCommerce is available.
add_action( 'plugins_loaded', 'paiw_init' );

