<?php
/**
 * Shortcode class.
 *
 * @package Product_Attribute_Icons_WooCommerce
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Shortcode handler class.
 */
class PAIW_Shortcode {

	/**
	 * The single instance of the class.
	 *
	 * @var PAIW_Shortcode
	 */
	private static $instance = null;

	/**
	 * Get the singleton instance.
	 *
	 * @return PAIW_Shortcode
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor.
	 */
	private function __construct() {
		add_shortcode( 'paiw_product_attribute_icons', array( $this, 'render_shortcode' ) );
	}

	/**
	 * Render shortcode.
	 *
	 * @param array $atts Shortcode attributes.
	 * @return string Shortcode output.
	 */
	public function render_shortcode( $atts ) {
		// Parse attributes.
		$atts = shortcode_atts(
			array(
				'id'    => 0,
				'class' => '',
			),
			$atts,
			'paiw_product_attribute_icons'
		);

		// Determine product ID.
		$product_id = absint( $atts['id'] );

		if ( empty( $product_id ) ) {
			global $post;
			if ( isset( $post->ID ) ) {
				$product_id = $post->ID;
			}
		}

		// Validate product exists.
		if ( empty( $product_id ) || ! wc_get_product( $product_id ) ) {
			return '';
		}

		// Get icons HTML.
		$icons_html = PAIW_Render::get_icons( $product_id );

		if ( empty( $icons_html ) ) {
			return '';
		}

		// Apply custom wrapper class if provided.
		if ( ! empty( $atts['class'] ) ) {
			// Sanitize multiple classes.
			$classes = array_map( 'sanitize_html_class', explode( ' ', $atts['class'] ) );
			$custom_class = esc_attr( implode( ' ', array_filter( $classes ) ) );
			// Add custom class to wrapper.
			if ( ! empty( $custom_class ) ) {
				$icons_html = str_replace( 'class="paiw-wrapper', 'class="paiw-wrapper ' . $custom_class, $icons_html );
			}
		}

		return $icons_html;
	}
}



