<?php

/**
 * @package paocfbfw
 * @author wpsaad
 * @link https://wpsaad.com
 * @since 1.0.0
 */
/**
 * Plugin Name: Product Add-Ons, Custom Fields, Booking & Extra Options for WooCommerce
 * plugin URI: https://wpsaad.com/product/product-addons-custom-fields-booking-for-woocommerce/
 * Description: Adds custom fields and add-ons to WooCommerce products using a custom post type.
 * Version: 1.1.0
 * Author: WPSAAD
 * Author URI: https://wpsaad.com
 * License: GPLv2 or later
 * Text Domain: product-addons-custom-fields-booking-for-woocommerce
 * Domain Path: /languages
 * Requires Plugins: woocommerce
 * Requires at least: 5.3
 */
defined( 'ABSPATH' ) or die;
define( 'PAOCFBFW_VERSION', '1.0.0' );
if ( function_exists( 'paocfbfw_fs' ) ) {
    paocfbfw_fs()->set_basename( false, __FILE__ );
} else {
    // DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE `function_exists` CALL ABOVE TO PROPERLY WORK.
    if ( !function_exists( 'paocfbfw_fs' ) ) {
        // Create a helper function for easy SDK access.
        function paocfbfw_fs() {
            global $paocfbfw_fs;
            if ( !isset( $paocfbfw_fs ) ) {
                // Include Freemius SDK.
                require_once dirname( __FILE__ ) . '/vendor/freemius/start.php';
                $paocfbfw_fs = fs_dynamic_init( array(
                    'id'               => '19444',
                    'slug'             => 'product-addons-custom-fields-booking-for-woocommerce',
                    'premium_slug'     => 'product-addons-custom-fields-booking-for-woocommerce-pro',
                    'type'             => 'plugin',
                    'public_key'       => 'pk_37744d58dc83a6dd8d5772964e0a0',
                    'is_premium'       => false,
                    'is_org_compliant' => true,
                    'premium_suffix'   => 'Pro',
                    'has_addons'       => false,
                    'has_paid_plans'   => true,
                    'menu'             => array(
                        'slug' => 'edit.php?post_type=pacfw-product-addons',
                    ),
                    'is_live'          => true,
                ) );
            }
            return $paocfbfw_fs;
        }

        // Init Freemius.
        paocfbfw_fs();
        // Signal that SDK was initiated.
        do_action( 'paocfbfw_fs_loaded' );
    }
    class paocfbfw_Plugin {
        /**
         * Build the instance
         */
        public function __construct() {
            register_activation_hook( __FILE__, array($this, 'install') );
            add_action( 'admin_init', [$this, 'paocfbfw_admin_functions'] );
            add_action( 'admin_enqueue_scripts', [$this, 'paocfbfw_admin_scripts'] );
            add_action( 'wp_enqueue_scripts', [$this, 'paocfbfw_front_scripts'] );
            add_action( 'woocommerce_loaded', array($this, 'paocfbfw_load_plugin'), 99 );
            // add_filter( 'rwmb_meta_boxes', [ $this, 'paocfbfw_post_settings' ] );
            // Hook registration moved to paocfbfw_load_plugin to ensure CMB2 is loaded first
            // Also add as fallback on admin_init with late priority
            add_action( 'admin_init', [$this, 'register_paocfbfw_cmb2_meta_boxes'], 999 );
            add_action( 'woocommerce_before_add_to_cart_button', [$this, 'paocfbfw_front_fields'] );
            // add_action('woocommerce_after_add_to_cart_button', [$this, 'paocfbfw_front_fields']);
            // add_action('woocommerce_product_meta_start', [$this, 'paocfbfw_front_fields']);
            // add_action('woocommerce_product_meta_end', [$this, 'paocfbfw_front_fields']);
            // add_action('woocommerce_single_product_summary', [$this, 'paocfbfw_front_fields']);
            add_filter(
                'pll_copy_post_metas',
                [$this, 'disable_polylang_meta_sync_for_product_addons_custom_fields'],
                10,
                3
            );
            add_filter(
                'pll_get_post_types',
                [$this, 'add_product_addons_custom_fields_to_pll'],
                10,
                2
            );
            //Handle Front Addons Fields
            add_filter(
                'woocommerce_add_cart_item_data',
                [$this, 'save_paocfbfw_fields_to_cart'],
                10,
                2
            );
            add_filter(
                'woocommerce_get_item_data',
                [$this, 'display_paocfbfw_fields_in_cart'],
                10,
                2
            );
            add_action(
                'woocommerce_checkout_create_order_line_item',
                [$this, 'save_paocfbfw_fields_to_order'],
                10,
                4
            );
            add_action(
                'woocommerce_before_calculate_totals',
                [$this, 'handle_paocfbfw_calculate_cart_item_price'],
                10,
                1
            );
            // Fix for pw_multiselect fields to save multiple values properly
            add_filter(
                'cmb2_sanitize_pw_multiselect',
                [$this, 'sanitize_pw_multiselect_field'],
                20,
                4
            );
        }

        /* paocfbfw Settings */
        public function get_paocfbfw_settings( $settings ) {
            $product_types_ids = get_posts( array(
                'fields'         => 'ids',
                'posts_per_page' => -1,
                'post_type'      => 'pacfw-product-addons',
            ) );
            if ( !empty( $product_types_ids ) ) {
                foreach ( $product_types_ids as $type_id ) {
                    $product_type_single = sanitize_text_field( get_post_meta( $type_id, 'paocfbfw_product_type_name_singular', true ) );
                    $product_type_id = preg_replace( '/\\s+/', '_', trim( preg_replace( '/[^\\da-z ]/i', '', strtolower( $product_type_single ) ) ) );
                    $product_type_class = preg_replace( '/\\s+/', '-', trim( preg_replace( '/[^\\da-z ]/i', '', strtolower( $product_type_single ) ) ) );
                    $product_type_plural = sanitize_text_field( get_post_meta( $type_id, 'paocfbfw_product_type_name_plural', true ) );
                    $product_type_tax_status = get_post_meta( $type_id, 'paocfbfw_custom_taxonomy', true );
                    $product_type_addons_fields = get_post_meta( $type_id, 'paocfbfw_product_tab_fields', true );
                    //Product Addons
                    $product_addons_title_text = get_post_meta( $type_id, 'paocfbfw_product_tab_title', true );
                    if ( $product_type_addons_fields ) {
                        $paocfbfw_addons[] = [
                            'text'   => $product_addons_title_text,
                            'fields' => $product_type_addons_fields,
                        ];
                    }
                    // var_dump($paocfbfw_addons);
                    $types_names_single[] = $product_type_single;
                    $types_names_plural[] = $product_type_plural;
                    $types_tax_status[] = $product_type_tax_status;
                    $types_ids[] = $product_type_id;
                    $types_classes[] = $product_type_class;
                }
                switch ( $settings ) {
                    case 'single':
                        return $types_names_single;
                    case 'ID':
                        return $types_ids;
                    case 'type_id':
                        return $type_id;
                    case 'class':
                        return $types_classes;
                    case 'plural':
                        return $types_names_plural;
                    case 'status':
                        return $types_tax_status;
                    case 'front_addons':
                        if ( isset( $paocfbfw_addons ) ) {
                            return $paocfbfw_addons;
                        }
                        break;
                }
            }
            // return $types_names_single;
        }

        public function handle_paocfbfw_calculate_cart_item_price( $cart ) {
            if ( is_admin() && !defined( 'DOING_AJAX' ) ) {
                return;
            }
            foreach ( $cart->get_cart() as $cart_item ) {
                if ( isset( $cart_item['paocfbfw_field_price'] ) ) {
                    $base_price = floatval( $cart_item['data']->get_price() );
                    $addon_price = floatval( $cart_item['paocfbfw_field_price'] );
                    $cart_item['data']->set_price( $base_price + $addon_price );
                }
            }
        }

        public function save_paocfbfw_fields_to_cart( $cart_item_data, $product_id ) {
            if ( isset( $_POST['nonce_CMB2phppaocfbfw_front_fields_addons'] ) && wp_verify_nonce( sanitize_key( wp_unslash( $_POST['nonce_CMB2phppaocfbfw_front_fields_addons'] ) ), 'nonce_CMB2phppaocfbfw_front_fields_addons' ) ) {
                $paocfbfw_addons = $this->get_paocfbfw_settings( 'front_addons' );
                $prefix = 'paocfbfw_';
                $total_price = 0;
                foreach ( $paocfbfw_addons as $addons ) {
                    $fields = $addons['fields'];
                    if ( !empty( $fields ) ) {
                        foreach ( $fields as $field ) {
                            $label = ( isset( $field[$prefix . 'label'] ) ? esc_html( $field[$prefix . 'label'] ) : '' );
                            $field_id = str_replace( '-', '_', sanitize_title( $label ) );
                            $options = ( isset( $field[$prefix . 'options'] ) ? explode( '|', $field[$prefix . 'options'] ) : [] );
                            // Create options price map
                            $option_prices = [];
                            foreach ( $options as $option ) {
                                if ( strpos( $option, ':' ) !== false ) {
                                    list( $opt_label, $opt_price ) = explode( ':', trim( $option ) );
                                    $option_key = str_replace( '-', '_', sanitize_title( $opt_label ) );
                                    $option_prices[$option_key] = floatval( $opt_price );
                                }
                            }
                            if ( isset( $_POST[$field_id] ) ) {
                                // Handle array values (checkboxes/multiselect)
                                if ( is_array( $_POST[$field_id] ) ) {
                                    $selected_values = array_map( 'sanitize_text_field', wp_unslash( $_POST[$field_id] ) );
                                    $cart_item_data['paocfbfw_addons_fields'][$field_id] = $selected_values;
                                    // Add prices for selected options
                                    foreach ( $selected_values as $value ) {
                                        if ( isset( $option_prices[$value] ) ) {
                                            $total_price += $option_prices[$value];
                                        }
                                    }
                                } else {
                                    $value = sanitize_text_field( wp_unslash( $_POST[$field_id] ) );
                                    $cart_item_data['paocfbfw_addons_fields'][$field_id] = $value;
                                    // Add price for single selection
                                    if ( isset( $option_prices[$value] ) ) {
                                        $total_price += $option_prices[$value];
                                    }
                                    // Add price for normal checkbox if it's checked and has a price
                                    if ( $field[$prefix . 'type'] === 'checkbox' && $value === 'on' && isset( $field[$prefix . 'price'] ) ) {
                                        $total_price += floatval( $field[$prefix . 'price'] );
                                    }
                                }
                            }
                        }
                    }
                }
                if ( $total_price > 0 ) {
                    $cart_item_data['paocfbfw_field_price'] = $total_price;
                }
                $cart_item_data['unique_key'] = md5( microtime() . wp_rand() );
            }
            return $cart_item_data;
        }

        public function display_paocfbfw_fields_in_cart( $item_data, $cart_item ) {
            //displays data on cart page and cherckout page
            // $product = wc_get_product($cart_item['product_id']);
            $paocfbfw_addons = $this->get_paocfbfw_settings( 'front_addons' );
            // var_dump($paocfbfw_addons);
            if ( !empty( $cart_item['paocfbfw_addons_fields'] ) ) {
                foreach ( $paocfbfw_addons as $addons ) {
                    $fields = $addons['fields'];
                    // var_dump($fields);
                    // var_dump($cart_item['paocfbfw_addons_fields']);
                    if ( !empty( $fields ) ) {
                        foreach ( $fields as $field ) {
                            $prefix = 'paocfbfw_';
                            $label = ( isset( $field[$prefix . 'label'] ) ? ucfirst( str_replace( '_', ' ', $field[$prefix . 'label'] ) ) : '' );
                            // $label = isset($field['label']) ? esc_html() : '';
                            $field_id = str_replace( '-', '_', sanitize_title( $label ) );
                            $field_data = ( isset( $cart_item['paocfbfw_addons_fields'][$field_id] ) ? $cart_item['paocfbfw_addons_fields'][$field_id] : '' );
                            // var_dump($field);
                            // var_dump($cart_item['paocfbfw_addons_fields'][$field_id]);
                            // add field icon if exists
                            if ( isset( $field['iconselect'] ) && !empty( $field['iconselect'] ) ) {
                                $icon = '<i class="' . esc_attr( $field['iconselect'] ) . '" style="margin-right: 10px;"></i>';
                                $label = $icon . $label;
                            }
                            if ( isset( $field_data ) && !empty( $field_data ) ) {
                                if ( $field[$prefix . 'type'] == 'file' || $field[$prefix . 'type'] == 'files' ) {
                                    $field_data = 'File Attachment';
                                }
                                // Handle array values
                                if ( is_array( $field_data ) ) {
                                    $field_data = implode( ', ', $field_data );
                                }
                                //
                                // Handle select/radio/multicheck values with prices
                                if ( in_array( $field[$prefix . 'type'], ['select', 'radio', 'multicheck'] ) ) {
                                    $option_prices = ( isset( $field[$prefix . 'options'] ) ? explode( '|', $field[$prefix . 'options'] ) : [] );
                                    $formatted_options_prices = [];
                                    foreach ( $option_prices as $option ) {
                                        if ( strpos( $option, ':' ) !== false ) {
                                            list( $opt_label, $opt_price ) = explode( ':', trim( $option ) );
                                            $formatted_options_prices[str_replace( '-', '_', sanitize_title( $opt_label ) )] = floatval( $opt_price );
                                        }
                                    }
                                    // var_dump($formatted_options_prices);
                                    if ( isset( $formatted_options_prices[$field_data] ) ) {
                                        $field_data .= ' (' . wc_price( $formatted_options_prices[$field_data] ) . ')';
                                    }
                                } elseif ( $field[$prefix . 'type'] == 'checkbox' && isset( $field[$prefix . 'price'] ) && !empty( $field[$prefix . 'price'] ) ) {
                                    // If checkbox has a price, append it
                                    $field_data = ' (' . wc_price( floatval( $field[$prefix . 'price'] ) ) . ')';
                                }
                                $item_data[] = array(
                                    'name'  => wp_kses_post( $label ),
                                    'value' => wc_clean( $field_data ),
                                );
                            }
                        }
                    }
                }
                // var_dump($item_data);
            }
            return $item_data;
        }

        public function save_paocfbfw_fields_to_order(
            $item,
            $cart_item_key,
            $values,
            $order
        ) {
            // if (paocfbfw_fs()->is__premium_only()) {
            // var_dump($values);
            if ( isset( $values['paocfbfw_addons_fields'] ) ) {
                foreach ( $values['paocfbfw_addons_fields'] as $key => $value ) {
                    $item->add_meta_data( ucfirst( str_replace( '_', ' ', $key ) ), $value );
                }
            }
            // }
        }

        public function paocfbfw_front_fields() {
            global $product;
            $product_id = $product->get_id();
            $current_hook = current_action();
            $paocfbfw_addons = array();
            $prefix = 'paocfbfw_';
            // Get all pacfw-product-addons post IDs
            $field_post_ids = get_posts( array(
                'post_type'      => 'pacfw-product-addons',
                'posts_per_page' => -1,
                'fields'         => 'ids',
            ) );
            foreach ( $field_post_ids as $post_id ) {
                $should_display = true;
                $enable_conditions = get_post_meta( $post_id, $prefix . 'enable_display_conditions', true );
                if ( $enable_conditions === 'on' ) {
                    // Check product categories
                    $allowed_categories = get_post_meta( $post_id, $prefix . 'display_condition_categories', true );
                    // var_dump($allowed_categories);
                    if ( !empty( $allowed_categories ) ) {
                        $product_categories = wp_get_post_terms( $product_id, 'product_cat', [
                            'fields' => 'slugs',
                        ] );
                        if ( !array_intersect( $product_categories, $allowed_categories ) ) {
                            $should_display = false;
                        }
                    }
                    // Check product tags
                    $allowed_tags = get_post_meta( $post_id, $prefix . 'display_condition_tags', true );
                    if ( !empty( $allowed_tags ) && $should_display ) {
                        $product_tags = wp_get_post_terms( $product_id, 'product_tag', [
                            'fields' => 'slugs',
                        ] );
                        if ( !array_intersect( $product_tags, $allowed_tags ) ) {
                            $should_display = false;
                        }
                    }
                    // Check specific products
                    $allowed_products = get_post_meta( $post_id, $prefix . 'display_condition_products', true );
                    // var_dump($allowed_products);
                    if ( !empty( $allowed_products ) && $should_display ) {
                        if ( !in_array( $product_id, $allowed_products ) ) {
                            $should_display = false;
                        }
                    }
                    // Check user roles
                    $allowed_roles = get_post_meta( $post_id, $prefix . 'display_condition_user_roles', true );
                    if ( !empty( $allowed_roles ) && $should_display ) {
                        $current_user = wp_get_current_user();
                        if ( !array_intersect( $current_user->roles, $allowed_roles ) ) {
                            $should_display = false;
                        }
                    }
                    // If all conditions are met, get the fields
                }
                // Add Fields to the array if should_display is true
                if ( $should_display ) {
                    $tab_fields = get_post_meta( $post_id, $prefix . 'product_tab_fields', true );
                    $tab_label = get_post_meta( $post_id, $prefix . 'product_fields_title', true );
                    if ( !empty( $tab_fields ) ) {
                        $paocfbfw_addons[] = [
                            'text'   => $tab_label,
                            'fields' => $tab_fields,
                        ];
                        // var_dump($tab_fields);
                    }
                }
            }
            if ( $paocfbfw_addons !== null && !empty( $paocfbfw_addons ) ) {
                //Front Addons Functionality
                if ( $current_hook == 'woocommerce_before_add_to_cart_button' ) {
                    foreach ( $paocfbfw_addons as $key => $addons ) {
                        $fields = $addons['fields'];
                        $fields_title = $addons['text'];
                        $cmb = new_cmb2_box( array(
                            'id'           => "{$prefix}front_fields_addons",
                            'title'        => ( !empty( $fields_title ) ? esc_html( $fields_title ) : __( 'Custom Fields', 'product-addons-custom-fields-booking-for-woocommerce' ) ),
                            'object_types' => array('product'),
                            'classes'      => 'paocfbfw-addons-fields',
                        ) );
                        // Fields addons title
                        // if (!empty($fields_title)) {
                        //     echo '<h4>' . esc_html($fields_title) . '</h4>';
                        // }
                        $cmb->add_field( array(
                            'name'    => $fields_title,
                            'type'    => 'title',
                            'id'      => $prefix . 'field_group_title_' . $key + 1,
                            'classes' => 'paocfbfw-field-title',
                        ) );
                        // Fields addons
                        if ( !empty( $fields ) ) {
                            foreach ( $fields as $field ) {
                                $type = ( isset( $field[$prefix . 'type'] ) ? $field[$prefix . 'type'] : 'text' );
                                $required = ( isset( $field[$prefix . 'required'] ) && $field[$prefix . 'required'] == 'on' ? true : false );
                                $label = ( isset( $field[$prefix . 'label'] ) ? esc_html( $field[$prefix . 'label'] ) : '' );
                                $description = ( isset( $field[$prefix . 'description'] ) ? esc_html( $field[$prefix . 'description'] ) : '' );
                                $field_id = str_replace( '-', '_', sanitize_title( $label ) );
                                $options = ( isset( $field[$prefix . 'options'] ) ? explode( '|', $field[$prefix . 'options'] ) : [] );
                                $options_types = ['select', 'radio', 'multicheck'];
                                $taxonomy_types = [
                                    'taxonomy_radio',
                                    'taxonomy_radio_inline',
                                    'taxonomy_radio_hierarchical',
                                    'taxonomy_select',
                                    'taxonomy_multicheck',
                                    'taxonomy_multicheck_inline',
                                    'taxonomy_multicheck_hierarchical'
                                ];
                                if ( is_rtl() ) {
                                    $space = 'margin-left';
                                } else {
                                    $space = 'margin-right';
                                }
                                if ( !empty( $field['iconselect'] ) ) {
                                    $icon = '<i class="' . esc_attr( $field['iconselect'] ) . '" style="' . esc_attr( $space ) . ': 10px;"></i>';
                                    $label = $icon . $label;
                                }
                                // var_dump($type);
                                $args = array(
                                    'name'       => $label . (( $required ? ' <span class="required">*</span>' : '' )),
                                    'desc'       => $description,
                                    'id'         => ( empty( $field_id ) ? 'paocfbfw_field_' . wp_rand( 1, 999 ) : $field_id ),
                                    'type'       => $type,
                                    'attributes' => array(
                                        'required' => $required,
                                    ),
                                );
                                // Handle specific field type options
                                if ( in_array( $type, $options_types ) && !empty( $options ) ) {
                                    $args['type'] = $type;
                                    $args['options'] = array();
                                    // If options are formatted with prices, handle them
                                    // add options pricing logic to detect : and set price in array ex: (Option1:10 | Option2:20)
                                    $formatted_options_prices = [];
                                    foreach ( $options as $option ) {
                                        if ( strpos( $option, ':' ) !== false ) {
                                            // Only process prices if they exist
                                            // var_dump($option);
                                            $parts = explode( ':', $option );
                                            $label = trim( $parts[0] );
                                            $price = ( isset( $parts[1] ) ? floatval( trim( $parts[1] ) ) : 0 );
                                            $formatted_options_prices[str_replace( '-', '_', sanitize_title( $label ) )] = [
                                                'label' => $label,
                                                'price' => $price,
                                            ];
                                            // var_dump($parts[0]);
                                        } else {
                                            $option = trim( $option );
                                            if ( !empty( $option ) ) {
                                                $args['options'][$option] = $option;
                                            }
                                        }
                                        // var_dump($option);
                                        // $options = $formatted_options_prices;
                                    }
                                    // var_dump($formatted_options_prices);
                                    if ( !empty( $formatted_options_prices ) ) {
                                        $args['options'] = array();
                                        foreach ( $formatted_options_prices as $option_key => $option_data ) {
                                            $args['options'][$option_key] = $option_data['label'];
                                            if ( isset( $option_data['price'] ) && $option_data['price'] > 0 ) {
                                                $args['options'][$option_key] .= ' (' . wp_kses_post( wc_price( $option_data['price'] ) ) . ')';
                                                // Escape wc_price output
                                                $args['attributes']['data-price-' . $option_key] = $option_data['price'];
                                            }
                                            $args['render_row_cb'] = function ( $field_args, $field ) {
                                                $html = '<div class="cmb-row cmb-type-' . esc_attr( $field_args['type'] ) . '">';
                                                if ( $field_args['type'] === 'select' ) {
                                                    $html .= '<div class="cmb-th"><label for="' . esc_attr( $field_args['id'] ) . '">' . wp_kses_post( $field_args['name'] ) . '</label></div>';
                                                    $html .= '<div class="cmb-td">';
                                                    $html .= '<select name="' . esc_attr( $field_args['id'] ) . '" id="' . esc_attr( $field_args['id'] ) . '" class="cmb2-select paocfbfw-price-field">';
                                                    foreach ( $field_args['options'] as $value => $label ) {
                                                        $data_price = ( isset( $field_args['attributes']['data-price-' . $value] ) ? ' data-price="' . esc_attr( $field_args['attributes']['data-price-' . $value] ) . '"' : '' );
                                                        $html .= '<option value="' . esc_attr( $value ) . '"' . $data_price . '>' . wp_kses_post( $label ) . '</option>';
                                                    }
                                                    $html .= '</select>';
                                                } elseif ( in_array( $field_args['type'], ['radio', 'multicheck'] ) ) {
                                                    $html .= '<div class="cmb-th"><label>' . wp_kses_post( $field_args['name'] ) . '</label></div>';
                                                    $html .= '<div class="cmb-td">';
                                                    $input_name = ( $field_args['type'] === 'multicheck' ? $field_args['id'] . '[]' : $field_args['id'] );
                                                    foreach ( $field_args['options'] as $value => $label ) {
                                                        $data_price = ( isset( $field_args['attributes']['data-price-' . $value] ) ? ' data-price="' . esc_attr( $field_args['attributes']['data-price-' . $value] ) . '"' : '' );
                                                        $html .= sprintf(
                                                            '<input type="%s" name="%s" id="%s_%s" value="%s" class="paocfbfw-price-field"%s>',
                                                            ( $field_args['type'] === 'multicheck' ? 'checkbox' : 'radio' ),
                                                            esc_attr( $input_name ),
                                                            esc_attr( $field_args['id'] ),
                                                            esc_attr( $value ),
                                                            esc_attr( $value ),
                                                            $data_price
                                                        );
                                                        $html .= '<label for="' . esc_attr( $field_args['id'] . '_' . $value ) . '">' . wp_kses_post( $label ) . '</label><br>';
                                                    }
                                                }
                                                // Escape description
                                                if ( !empty( $field_args['desc'] ) ) {
                                                    $html .= '<p class="cmb2-metabox-description">' . wp_kses_post( $field_args['desc'] ) . '</p>';
                                                }
                                                $html .= '</div></div>';
                                                return $html;
                                                // Return the HTML without escaping it entirely
                                            };
                                        }
                                        // var_dump( $args['options']);
                                    } else {
                                        $args['options'] = array_combine( $options, $options );
                                    }
                                    // $args['options'] = array_combine($options, $options);
                                    ( $type === 'select' ? $args['show_option_none'] = false : '' );
                                }
                                if ( $type === 'textarea' ) {
                                    $args['attributes'] = array(
                                        'rows' => 5,
                                    );
                                }
                                if ( $type === 'checkbox' ) {
                                    //add $args['render_row_cb'] and data-price if checkbox field meta has paocfbfw_price
                                    if ( isset( $field[$prefix . 'price'] ) && !empty( $field[$prefix . 'price'] ) ) {
                                        $args['attributes']['data-price'] = floatval( $field[$prefix . 'price'] );
                                        $args['render_row_cb'] = function ( $field_args, $field ) {
                                            $html = '';
                                            $html .= '<div class="cmb-row cmb-type-checkbox">';
                                            // Escape the name field and ensure the price is properly escaped
                                            $html .= '<div class="cmb-th"><label for="' . esc_attr( $field_args['id'] ) . '">' . wp_kses_post( $field_args['name'] ) . ' (' . wp_kses_post( wc_price( $field_args['attributes']['data-price'] ) ) . ')</label></div>';
                                            $html .= '<div class="cmb-td">';
                                            $html .= '<input type="checkbox" name="' . esc_attr( $field_args['id'] ) . '" id="' . esc_attr( $field_args['id'] ) . '" value="on" class="cmb2-option cmb2-list paocfbfw-price-field" data-price="' . esc_attr( $field_args['attributes']['data-price'] ) . '" data-hash="' . esc_attr( uniqid() ) . '">';
                                            $html .= '<label for="' . esc_attr( $field_args['id'] ) . '">';
                                            if ( !empty( $field_args['desc'] ) ) {
                                                // Escape the description using wp_kses_post() to allow safe HTML tags
                                                $html .= '<span class="cmb2-metabox-description">' . wp_kses_post( $field_args['desc'] ) . '</span>';
                                            }
                                            $html .= '</label>';
                                            $html .= '</div></div>';
                                            return $html;
                                            // Don't escape the entire HTML, return it as is.
                                        };
                                    }
                                    $args['default'] = 'off';
                                }
                                if ( $type === 'file' ) {
                                    $args['options'] = array(
                                        'url' => false,
                                    );
                                }
                                if ( $type === 'country' ) {
                                    $countries_obj = new WC_Countries();
                                    $countries = $countries_obj->__get( 'countries' );
                                    $args['type'] = 'select';
                                    $args['options'] = $countries;
                                    // var_dump($args);
                                }
                                if ( $type === 'text_url' ) {
                                    $args['attributes']['class'] = 'paocfbfw-url-field';
                                    $args['attributes']['placeholder'] = 'https://example.com';
                                }
                                if ( in_array( $type, $taxonomy_types ) ) {
                                    $args['taxonomy'] = $field[$prefix . 'taxonomy'];
                                    $args['show_option_none'] = false;
                                }
                                $cmb->add_field( $args );
                                // var_dump($options);
                                // var_dump( $field);
                                // var_dump( $args);
                            }
                        }
                    }
                    cmb2_metabox_form( 'paocfbfw_front_fields_addons', $product_id, array(
                        'form_format' => '',
                    ) );
                }
            }
        }

        public function paocfbfw_admin_scripts( $hook ) {
            // Don't load on user profile/edit pages - prevents interference with profile form save button
            if ( in_array( $hook, array('profile.php', 'user-edit.php') ) ) {
                return;
            }
            wp_enqueue_script(
                'paocfbfw_admin_js',
                plugins_url( '/includes/js/paocfbfw_admin.js', __FILE__ ),
                [],
                PAOCFBFW_VERSION,
                true
            );
            wp_enqueue_script(
                'paocfbfw_cond_js',
                plugins_url( '/assets/js/cmb2-conditionals.js', __FILE__ ),
                [],
                PAOCFBFW_VERSION,
                true
            );
            wp_enqueue_script(
                'paocfbfw_shwitcher_js',
                plugins_url( '/assets/js/jquery.switcher.js', __FILE__ ),
                [],
                PAOCFBFW_VERSION,
                true
            );
            wp_enqueue_style(
                'paocfbfw_admin_css',
                plugins_url( '/assets/css/paocfbfw_admin.css', __FILE__ ),
                [],
                PAOCFBFW_VERSION
            );
            wp_enqueue_style(
                'paocfbfw_switcher_css',
                plugins_url( '/assets/css/switcher.css', __FILE__ ),
                [],
                PAOCFBFW_VERSION
            );
        }

        public function paocfbfw_front_scripts() {
            wp_enqueue_style(
                'paocfbfw_front_css',
                plugins_url( '/assets/css/paocfbfw_front.css', __FILE__ ),
                [],
                PAOCFBFW_VERSION
            );
            //enqueue script paocfbfw_front on product pages only
            if ( is_product() ) {
                wp_enqueue_script(
                    'paocfbfw_front_js',
                    plugins_url( '/includes/front/js/paocfbfw_front.js', __FILE__ ),
                    ['jquery', 'jquery-ui-datepicker'],
                    PAOCFBFW_VERSION,
                    true
                );
            }
            // wp_enqueue_script('paocfbfw_front_js', plugins_url('/includes/front/js/paocfbfw_front.js', __FILE__), ['jquery', 'jquery-ui-datepicker'], PAOCFBFW_VERSION, true);
            wp_enqueue_style(
                'fontawesomeiselect',
                plugins_url( 'vendor/cmb2-field-faiconselect/css/faws/css/font-awesome.min.css', __FILE__ ),
                [],
                PAOCFBFW_VERSION
            );
        }

        /**
         * Load WC Dependencies
         *
         * @return void
         */
        public function paocfbfw_load_plugin() {
            require_once plugin_dir_path( __FILE__ ) . 'includes/paocfbfw_functions.php';
            require_once plugin_dir_path( __FILE__ ) . 'includes/paocfbfw_select2_field.php';
            // Load CMB2 libraries if not already loaded through another plugin
            if ( !defined( 'CMB2_LOADED' ) ) {
                define( 'CMB2_LOADED', true );
            }
            // Load vendor files if CMB2 classes don't exist
            if ( !class_exists( 'CMB2' ) || !class_exists( 'CMB2_Tabs' ) ) {
                require_once plugin_dir_path( __FILE__ ) . 'vendor/autoload.php';
            }
            // Register metaboxes directly if CMB2 is available
            if ( function_exists( 'new_cmb2_box' ) ) {
                $this->register_paocfbfw_cmb2_meta_boxes();
            } else {
                // Fallback: Register on hooks if CMB2 loads later
                add_action( 'cmb2_init', [$this, 'register_paocfbfw_cmb2_meta_boxes'], 5 );
                if ( is_admin() ) {
                    add_action( 'cmb2_admin_init', [$this, 'register_paocfbfw_cmb2_meta_boxes'], 5 );
                }
            }
        }

        public function paocfbfw_admin_functions() {
            // Libraries should be autoloaded by composer
        }

        /**
         * Installing on activation
         *
         * @return void
         */
        public function install() {
            add_option( 'paocfbfw_activated', true );
            flush_rewrite_rules();
        }

        public function register_paocfbfw_cmb2_meta_boxes() {
            // Prevent loading fields multiple times
            if ( defined( 'PAOCFBFW_CMB2_REGISTERED' ) ) {
                return;
            }
            define( 'PAOCFBFW_CMB2_REGISTERED', true );
            // Ensure CMB2 functions are available
            if ( !function_exists( 'new_cmb2_box' ) ) {
                return;
            }
            require_once dirname( __FILE__ ) . '/includes/paocfbfw_fields.php';
        }

        public function fetch_booked_days() {
            $nonce_verify = ( isset( $_POST['nonce_CMB2phppaocfbfw_front_fields_addons'] ) ? wp_verify_nonce( sanitize_key( wp_unslash( $_POST['nonce_CMB2phppaocfbfw_front_fields_addons'] ) ), 'nonce_CMB2phppaocfbfw_front_fields_addons' ) : false );
        }

        public function get_product_booked_days( $product_id, $year, $month ) {
            global $wpdb;
            // // Get the calendar field label for this product
            // // Must be with space cause its saved in the database with space
            $meta_key = ucfirst( str_replace( '-', ' ', sanitize_title( $this->get_calendar_field_label( $product_id ) ) ) );
            // // Format dates properly using sprintf for consistent padding
            $start_date = sprintf( '%04d-%02d-01', $year, $month );
            $end_date = gmdate( 'Y-m-t', strtotime( $start_date ) );
            // Last day of the month
            // Query to fetch booked days between start and end date
            // Original wpdb query
            // $results = $wpdb->get_col(
            //     $wpdb->prepare(
            //         "SELECT DISTINCT DAY(STR_TO_DATE(meta_value, '%%d/%%m/%%Y'))
            //         FROM {$wpdb->prefix}woocommerce_order_itemmeta itemmeta
            //         INNER JOIN {$wpdb->prefix}woocommerce_order_items items ON itemmeta.order_item_id = items.order_item_id
            //         INNER JOIN {$wpdb->prefix}wc_order_product_lookup lookup ON items.order_item_id = lookup.order_item_id
            //         WHERE itemmeta.meta_key = %s
            //         AND lookup.product_id = %d
            //         AND STR_TO_DATE(meta_value, '%%d/%%m/%%Y') BETWEEN %s AND %s",
            //         $meta_key,
            //         $product_id,
            //         $start_date,
            //         $end_date
            //     )
            // );
            // var_dump($meta_key);
            // New WooCommerce order query approach
            $args = array(
                'status'       => array('wc-completed'),
                'limit'        => -1,
                'return'       => 'ids',
                'date_created' => $start_date . '...' . $end_date,
            );
            $orders = wc_get_orders( $args );
            $booked_days = array();
            foreach ( $orders as $order_id ) {
                $order = wc_get_order( $order_id );
                foreach ( $order->get_items() as $item ) {
                    if ( $item->get_product_id() == $product_id ) {
                        $meta_value = $item->get_meta( $meta_key );
                        // var_dump($meta_value);
                        if ( $meta_value ) {
                            $date = DateTime::createFromFormat( 'd/m/Y', $meta_value );
                            if ( $date ) {
                                $booked_days[] = (int) $date->format( 'd' );
                            }
                        }
                    }
                }
            }
            $booked_days = array_unique( $booked_days );
            $results = $booked_days;
            // Use the same variable name for consistency
            // var_dump($meta_key);
            return array_map( 'intval', $results );
        }

        private function get_calendar_field_label( $product_id ) {
            $paocfbfw_addons = $this->get_paocfbfw_settings( 'front_addons' );
            $prefix = 'paocfbfw_';
            if ( !empty( $paocfbfw_addons ) ) {
                foreach ( $paocfbfw_addons as $addons ) {
                    if ( !empty( $addons['fields'] ) ) {
                        foreach ( $addons['fields'] as $field ) {
                            if ( isset( $field[$prefix . 'type'] ) && $field[$prefix . 'type'] === 'calendar' ) {
                                return ( isset( $field[$prefix . 'label'] ) ? $field[$prefix . 'label'] : '' );
                            }
                        }
                    }
                }
            }
            return '';
        }

        public function disable_polylang_meta_sync_for_product_addons_custom_fields( $metas, $from, $to ) {
            $excluded_product_types = $this->get_paocfbfw_settings( 'ID' );
            // Replace with your specific product types
            $from_product_type = get_post_meta( $from, '_product_type', true );
            $to_product_type = get_post_meta( $to, '_product_type', true );
            if ( in_array( $from_product_type, $excluded_product_types ) || in_array( $to_product_type, $excluded_product_types ) ) {
                unset($metas['_product_type']);
                return $metas;
                // Disable syncing of all meta for these product types
            }
            return $metas;
        }

        public function add_product_addons_custom_fields_to_pll( $post_types, $is_settings ) {
            $post_types['pacfw-product-addons'] = 'pacfw-product-addons';
            return $post_types;
        }

        /**
         * Sanitize pw_multiselect fields to ensure arrays are properly saved
         * The original filter only handles repeatable fields, so we handle non-repeatable here
         */
        public function sanitize_pw_multiselect_field(
            $check,
            $meta_value,
            $object_id,
            $field_args
        ) {
            // Skip repeatable fields - original filter handles those
            if ( !empty( $field_args['repeatable'] ) ) {
                return $check;
            }
            // For non-repeatable pw_multiselect: return array
            // The original filter returns $check for non-repeatable, which may not be an array
            // meta_value from POST should be an array when name="field[]"
            if ( is_array( $meta_value ) && !empty( $meta_value ) ) {
                return array_map( 'sanitize_text_field', array_values( array_filter( $meta_value ) ) );
            }
            // If meta_value is not an array or empty, check if $check has the array
            // This handles cases where data might already be processed
            if ( is_array( $check ) && !empty( $check ) ) {
                return array_map( 'sanitize_text_field', array_values( array_filter( $check ) ) );
            }
            // Return empty array if nothing is set
            return array();
        }

    }

    new paocfbfw_Plugin();
}