<?php
/**
 * Custom CMB2 Select2 Field Type
 */
class PAOCFBFW_CMB2_Select2_Field {

    public function __construct() {
        add_filter('cmb2_render_custom_select2', array($this, 'render_custom_select2'), 10, 5);
        add_filter('cmb2_render_custom_multiselect2', array($this, 'render_custom_multiselect2'), 10, 5);
        add_filter('cmb2_sanitize_custom_multiselect2', array($this, 'sanitize_custom_multiselect2'), 10, 4);
    }

    public function render_custom_select2($field, $field_escaped_value, $field_object_id, $field_object_type, $field_type_object) {
        $this->setup_scripts();

        if (version_compare(CMB2_VERSION, '2.2.2', '>=')) {
            $field_type_object->type = new CMB2_Type_Select($field_type_object);
        }

        $args = array(
            'class'            => 'custom-select2',
            'desc'             => false, // We'll handle description separately
            'options'          => '<option></option>' . $field_type_object->concat_items(),
            'data-placeholder' => $field->args('attributes', 'placeholder') ? $field->args('attributes', 'placeholder') : $field->args('description'),
        );

        $select = $field_type_object->select($args);
        $desc = $field_type_object->_desc(true);
        
        echo $select . $desc;
    }

    public function render_custom_multiselect2($field, $field_escaped_value, $field_object_id, $field_object_type, $field_type_object) {
        $this->setup_scripts();

        if (version_compare(CMB2_VERSION, '2.2.2', '>=')) {
            $field_type_object->type = new CMB2_Type_Select($field_type_object);
        }

        $options = $this->get_multiselect_options($field_type_object, $field_escaped_value);

        $args = array(
            'multiple'         => 'multiple',
            'class'            => 'custom-select2-multi',
            'name'             => $field_type_object->_name() . '[]',
            'id'               => $field_type_object->_id(),
            'desc'             => false, // We'll handle description separately
            'options'          => $options,
            'data-placeholder' => $field->args('attributes', 'placeholder') ? $field->args('attributes', 'placeholder') : $field->args('description'),
        );

        $attrs = $field_type_object->concat_attrs($args, array('desc', 'options'));
        $select = sprintf('<select%s>%s</select>', $attrs, $args['options']);
        $desc = $field_type_object->_desc(true);
        
        // Wrap in a container for better styling
        echo '<div class="custom-select2-wrapper">' . $select . $desc . '</div>';
    }

    public function get_multiselect_options($field_type_object, $field_escaped_value = array()) {
        $options = (array) $field_type_object->field->options();

        if (!empty($field_escaped_value)) {
            $options = $this->sort_array_by_array($options, $field_escaped_value);
        }

        $selected_items = '';
        $other_items = '';

        foreach ($options as $option_value => $option_label) {
            $option = array(
                'value' => $option_value,
                'label' => $option_label,
            );

            if (in_array($option_value, (array) $field_escaped_value)) {
                $option['checked'] = true;
                $selected_items .= $field_type_object->select_option($option);
            } else {
                $other_items .= $field_type_object->select_option($option);
            }
        }

        return $selected_items . $other_items;
    }

    public function sort_array_by_array(array $array, array $orderArray) {
        $ordered = array();
        foreach ($orderArray as $key) {
            if (array_key_exists($key, $array)) {
                $ordered[$key] = $array[$key];
                unset($array[$key]);
            }
        }
        return $ordered + $array;
    }

    public function sanitize_custom_multiselect2($check, $meta_value, $object_id, $field_args) {
        if (!is_array($meta_value) || empty($field_args['repeatable'])) {
            return $check;
        }
        foreach ($meta_value as $key => $val) {
            $meta_value[$key] = array_map('sanitize_text_field', $val);
        }
        return $meta_value;
    }

    public function setup_scripts() {
        // Enqueue Select2 from assets (not from old cmb-field-select2 vendor folder)
        // Get the main plugin file path (go up from includes/ to plugin root)
        $plugin_path = dirname(dirname(__FILE__)) . '/product-addons-custom-fields-booking-for-woocommerce.php';
        wp_enqueue_script('custom-select2-js', plugins_url('/assets/js/select2.min.js', $plugin_path), array('jquery'), '4.1.0-rc.0', true);
        wp_enqueue_script('custom-select2-init', plugins_url('/includes/js/custom-select2.js', $plugin_path), array('custom-select2-js'), '1.0.0', true);
        wp_enqueue_style('custom-select2-css', plugins_url('/assets/css/select2.min.css', $plugin_path), array(), '4.1.0-rc.0');
    }
}

new PAOCFBFW_CMB2_Select2_Field();

