<?php
    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

    // Ensure CMB2 is loaded before creating metaboxes
    if ( ! function_exists( 'new_cmb2_box' ) ) {
        return;
    }

function paocfbfw_get_products_options()
{
	$products = wc_get_products(array('limit' => -1));
	$options = array();
	foreach ($products as $product) {
		$options[$product->get_id()] = $product->get_name();
	}
	return $options;
}

function paocfbfw_get_taxonomy_options_cb($taxonomy)
{
	$options = array();
	$terms = get_terms(array(
		'taxonomy' => $taxonomy,
		'hide_empty' => false,
	));
	if (!is_wp_error($terms)) {
		foreach ($terms as $term) {
			// Use slug as key for compatibility with most CMB2 select fields
			// Decode URL-encoded slugs to handle Arabic/non-ASCII characters
			$slug = urldecode($term->slug);
			$options[$slug] = $term->name;
		}
	}
	return $options;
}
/*
 * Metaboxes Fields
 */


$prefix = 'paocfbfw_';

$box_options = array(
	'id'           => 'paocfbfw',
	'title'        => esc_html__('Custom WC Product Type Settings', 'product-addons-custom-fields-booking-for-woocommerce'),
	'object_types' => array('pacfw-product-addons'), // Post types.
	'context'      => 'normal',
	'priority'     => 'high',
);

// Setup meta box
$cmb = new_cmb2_box($box_options);

// Setting tabs
$tabs_setting = array(
	'config' => $box_options,
	// 'layout' => 'vertical', // Default : horizontal
	'tabs'   => array()
);

// Define FREE field types
$baisc_field_types = array(
	'text' => __('Text', 'product-addons-custom-fields-booking-for-woocommerce'),
	'text_url' => __('Link', 'product-addons-custom-fields-booking-for-woocommerce'),
	'text_email' => __('Email', 'product-addons-custom-fields-booking-for-woocommerce'),
	'text_date' => __('Date Picker', 'product-addons-custom-fields-booking-for-woocommerce'),
	'textarea' => __('Textarea', 'product-addons-custom-fields-booking-for-woocommerce'),
	'title' => __('Title', 'product-addons-custom-fields-booking-for-woocommerce'),
	'select' => __('Select', 'product-addons-custom-fields-booking-for-woocommerce'),
	'radio' => __('Radio', 'product-addons-custom-fields-booking-for-woocommerce'),
	'checkbox' => __('Checkbox', 'product-addons-custom-fields-booking-for-woocommerce'),
	'multicheck' => __('Multicheck', 'product-addons-custom-fields-booking-for-woocommerce'),
	'file' => __('File', 'product-addons-custom-fields-booking-for-woocommerce'),
);

// Define PRO field types (Premium functionality check)
if (function_exists('paocfbfw_fs') && paocfbfw_fs()->is__premium_only()) {
	$pro_field_types = array();
	$tax_query = get_object_taxonomies('product', 'objects');
	$tax_array = array();
	foreach ($tax_query as $tax) {
		$excluded_taxonomies = array('product_type', 'product_visibility', 'product_tag', 'product_shipping_class');
		if (in_array($tax->name, $excluded_taxonomies)) {
			continue;
		}
		$tax_array[$tax->name] = $tax->label;
	}

	$pro_field_types = array(
		'text_money' => __('Price', 'product-addons-custom-fields-booking-for-woocommerce'),
		'calendar' => __('Booking Calendar', 'product-addons-custom-fields-booking-for-woocommerce'),
		'text_datetime_timestamp' => __('Date/Time', 'product-addons-custom-fields-booking-for-woocommerce'),
		'text_datetime_timestamp_timezone' => __('Date/Time With City Time Zone', 'product-addons-custom-fields-booking-for-woocommerce'),
		'wysiwyg' => __('WYSIWYG Editor', 'product-addons-custom-fields-booking-for-woocommerce'),
		'country' => __('Country', 'product-addons-custom-fields-booking-for-woocommerce'),
		'colorpicker' => __('Color Picker', 'product-addons-custom-fields-booking-for-woocommerce'),
		'hidden' => __('Hidden', 'product-addons-custom-fields-booking-for-woocommerce'),
		'taxonomy_select' => __('Select Taxonomy', 'product-addons-custom-fields-booking-for-woocommerce'),
		'taxonomy_radio' => __('Radio Taxonomy', 'product-addons-custom-fields-booking-for-woocommerce'),
		'taxonomy_radio_inline' => __('Radio Taxonomy Inline', 'product-addons-custom-fields-booking-for-woocommerce'),
		'taxonomy_radio_hierarchical' => __('Radio Taxonomy Hierarchical', 'product-addons-custom-fields-booking-for-woocommerce'),
		'taxonomy_multicheck' => __('Multicheck Taxonomy', 'product-addons-custom-fields-booking-for-woocommerce'),
		'taxonomy_multicheck_inline' => __('Multicheck Inline Taxonomy', 'product-addons-custom-fields-booking-for-woocommerce'),
		'taxonomy_multicheck_hierarchical' => __('Multicheck Taxonomy Hierarchical', 'product-addons-custom-fields-booking-for-woocommerce'),
	);
}

if (isset($pro_field_types) && is_array($pro_field_types) && !empty($pro_field_types) && paocfbfw_fs()->is__premium_only()) {
	// Merge FREE and PRO field types
	$field_types = array_merge($baisc_field_types, $pro_field_types);
} else {
	$field_types = $baisc_field_types;
}

// Use the merged field types in the field definition
$tabs_setting['tabs'][] = array(
	'id'     => $prefix . 'product_fields', // Ensure unique ID
	'title'  => __('Product Add-ons', 'product-addons-custom-fields-booking-for-woocommerce'),
	'fields' => array(
		array(
			'type'        => 'text',
			'name'        => esc_html__('Product Add-ons Title', 'product-addons-custom-fields-booking-for-woocommerce'),
			'id'          => $prefix . 'product_fields_title', // Ensure unique ID
			'desc'        => esc_html__('Fields Tab Title', 'product-addons-custom-fields-booking-for-woocommerce'),
			'attributes'  => array(
				'required'               => false,
				'placeholder' => esc_html__('Title Text', 'product-addons-custom-fields-booking-for-woocommerce'),
			),
			'classes'     => 'product-fields-title',
		),
		array(
			'type'       => 'group',
			'name'       => esc_html__('Add Your fields below', 'product-addons-custom-fields-booking-for-woocommerce'),
			'id'         => $prefix . 'product_tab_fields', // Ensure unique ID
			'classes'    => 'product-tab-fields',
			'options'    => array(
				'group_title'   => esc_html__('Field {#}', 'product-addons-custom-fields-booking-for-woocommerce'),
				'add_button'    => esc_html__('Add Field', 'product-addons-custom-fields-booking-for-woocommerce'),
				'remove_button' => esc_html__('Remove Field', 'product-addons-custom-fields-booking-for-woocommerce'),
				'sortable'      => true,
				'closed'        => true,
			),
			'fields' => array(
				array(
					'name' => __('Select Font Awesome Icon', 'product-addons-custom-fields-booking-for-woocommerce'),
					'id'   => 'iconselect',
					'desc' => 'Select Font Awesome icon',
					'type' => 'faiconselect',
					'options_cb' => 'returnRayFaPre'
				),
				array(
					'name' => __('Field Type', 'product-addons-custom-fields-booking-for-woocommerce'),
					'id'   => $prefix . 'type', // Ensure unique ID
					'type' => 'select',
					'default' => 'text',
					'options' => $field_types, // Use the merged field types
				),
				array(
					'type'  => 'text',
					'name'  => esc_html__('Field Label/Name', 'product-addons-custom-fields-booking-for-woocommerce'),
					'id'    => $prefix . 'label', // Ensure unique ID
					'classes'    => 'field-label',
					'desc'  => esc_html__('Enter field label/Name. Please note: Changing this will make you lose old related data.', 'product-addons-custom-fields-booking-for-woocommerce'),
					'attributes'  => array(
						'required'               => false,
					),
				),
				array(
					'type'    => 'checkbox',
					'name'    => esc_html__('Required', 'product-addons-custom-fields-booking-for-woocommerce'),
					'id'      => $prefix . 'required', // Ensure unique ID
					'desc'    => esc_html__('Mark as required.', 'product-addons-custom-fields-booking-for-woocommerce'),
					'classes' => 'required',
				),
				array(
					'type'  => 'text',
					'name'  => esc_html__('Field Description', 'product-addons-custom-fields-booking-for-woocommerce'),
					'id'    => $prefix . 'description',
					'desc'  => esc_html__('Enter field description.', 'product-addons-custom-fields-booking-for-woocommerce'),
				),
				array(
					'name' => __('Options', 'product-addons-custom-fields-booking-for-woocommerce'),
					'id' => $prefix . 'options',
					'type' => 'textarea',
					'desc' => __('Use ( | ) To Separate options, For price use ex: (Option1:10 | Option2:20)', 'product-addons-custom-fields-booking-for-woocommerce'),
					'attributes'  => array(
						'data-conditional-id'     => wp_json_encode(array($prefix . 'product_tab_fields', $prefix . 'type')),
						'data-conditional-value'  => wp_json_encode(array('select', 'radio', 'multicheck')),
					),

				),
				// Price field
				array(
					'name' => __('Price', 'product-addons-custom-fields-booking-for-woocommerce'),
					'id' => $prefix . 'price',
					'type' => 'text_money',
					'desc' => __('Enter price for this field', 'product-addons-custom-fields-booking-for-woocommerce'),
					'attributes'  => array(
						'data-conditional-id'     => wp_json_encode(array($prefix . 'product_tab_fields', $prefix . 'type')),
						'data-conditional-value'  => wp_json_encode(array('checkbox')),
					),
				),


			),
		),
	),
);

// var_dump($tabs_setting['tabs'][0]['fields'][1]['fields']);

// // Only show Select Taxonomy field for premium users
if (function_exists('paocfbfw_fs') && paocfbfw_fs()->is__premium_only()) {

	$tabs_setting['tabs'][0]['fields'][1]['fields'][] = array(
		'name' => __('Select Taxonomy', 'product-addons-custom-fields-booking-for-woocommerce'),
		'id'   => $prefix . 'taxonomy',
		'type' => 'select',
		'options' =>  $tax_array,
		'attributes' => array(
			'data-conditional-id'     => wp_json_encode(array($prefix . 'product_tab_fields', $prefix . 'type')),
			'data-conditional-value' => wp_json_encode(array(
				'taxonomy_select',
				'taxonomy_radio',
				'taxonomy_radio_inline',
				'taxonomy_radio_hierarchical',
				'taxonomy_multicheck',
				'taxonomy_multicheck_inline',
				'taxonomy_multicheck_hierarchical'
			))
		),
		'default' => 'product_cat',
		'desc' => __('Select which taxonomy to use', 'product-addons-custom-fields-booking-for-woocommerce')
	);
	$tabs_setting['tabs'][0]['fields'][1]['fields'][] = array(
		'name' => __('Show Calendar Text Input', 'product-addons-custom-fields-booking-for-woocommerce'),
		'id' => $prefix . 'show_calendar_input',
		'type' => 'checkbox',
		'desc' => __('Show/Hide Date Text Field', 'product-addons-custom-fields-booking-for-woocommerce'),
		'attributes' => array(
			'data-conditional-id'     => wp_json_encode(array($prefix . 'product_tab_fields', $prefix . 'type')),
			'data-conditional-value' => wp_json_encode(array('calendar')),
		),
	);
	$tabs_setting['tabs'][0]['fields'][1]['fields'][] = 					array(
						'name' => __('Date Format', 'product-addons-custom-fields-booking-for-woocommerce'),
						'id' => $prefix . 'date_format',
						'type' => 'select',
						'default' => 'mm/dd/yy',
						'options' => array(
							'mm/dd/yy' => __('mm/dd/yy', 'product-addons-custom-fields-booking-for-woocommerce'),
							'dd/mm/yy' => __('dd/mm/yy', 'product-addons-custom-fields-booking-for-woocommerce'),
							'yy-mm-dd' => __('yy-mm-dd', 'product-addons-custom-fields-booking-for-woocommerce'),
							'dd.mm.yy' => __('dd.mm.yy', 'product-addons-custom-fields-booking-for-woocommerce'),
							'yy.mm.dd' => __('yy.mm.dd', 'product-addons-custom-fields-booking-for-woocommerce'),
							'd M, y' => __('d M, y', 'product-addons-custom-fields-booking-for-woocommerce'),
							'MM d, yy' => __('MM d, yy', 'product-addons-custom-fields-booking-for-woocommerce')
						),
						'attributes' => array(
			'data-conditional-id'     => wp_json_encode(array($prefix . 'product_tab_fields', $prefix . 'type')),
			'data-conditional-value' => wp_json_encode(array('calendar')),
						)
						);

		$tabs_setting['tabs'][0]['fields'][1]['fields'][] = array(
		'name' => __('Start Date', 'product-addons-custom-fields-booking-for-woocommerce'),
		'id' => $prefix . 'start_date',
		'type' => 'text_date',
		'desc' => __('Enter Start Date', 'product-addons-custom-fields-booking-for-woocommerce'),
		'attributes' => array(
			'data-conditional-id'     => wp_json_encode(array($prefix . 'product_tab_fields', $prefix . 'type')),
			'data-conditional-value' => wp_json_encode(array('calendar')),
		),
		'default' => '0',
	);

	$tabs_setting['tabs'][0]['fields'][1]['fields'][] = array(
		'name' => __('Max Date', 'product-addons-custom-fields-booking-for-woocommerce'),
		'id' => $prefix . 'end_date',
		'type' => 'text_date',
		'desc' => __('Enter End Date', 'product-addons-custom-fields-booking-for-woocommerce'),
		'attributes' => array(
			'data-conditional-id'     => wp_json_encode(array($prefix . 'product_tab_fields', $prefix . 'type')),
			'data-conditional-value' => wp_json_encode(array('calendar')),
		)
	);
}
// Add a new tab for Display Conditions
$tabs_setting['tabs'][] = array(
	'id'     => $prefix . 'display_conditions', // Ensure unique ID
	'title'  => __('Display Conditions', 'product-addons-custom-fields-booking-for-woocommerce'),
	'fields' => array(
		array(
			'name' => __('Enable Display Conditions', 'product-addons-custom-fields-booking-for-woocommerce'),
			'id'   => $prefix . 'enable_display_conditions', // Ensure unique ID
			'type' => 'checkbox',
			'desc' => __('Enable conditional logic, <strong>Off = Load in all products.</strong>', 'product-addons-custom-fields-booking-for-woocommerce'),
		),
		array(
			'name' => __('Product Categories', 'product-addons-custom-fields-booking-for-woocommerce'),
			'id'   => $prefix . 'display_condition_categories', // Ensure unique ID
			'type' => 'custom_multiselect2',
			'options' => paocfbfw_get_taxonomy_options_cb('product_cat'),
			'desc' => __('Select product categories where the fields should be displayed.', 'product-addons-custom-fields-booking-for-woocommerce'),
			'attributes' => array(
				'data-conditional-id'     => $prefix . 'enable_display_conditions',
				'data-conditional-value' => wp_json_encode(array('on')),
			)
		),
		array(
			'name' => __('Product Tags', 'product-addons-custom-fields-booking-for-woocommerce'),
			'id'   => $prefix . 'display_condition_tags', // Ensure unique ID
			'type' => 'custom_multiselect2',
			'options' => paocfbfw_get_taxonomy_options_cb('product_tag'),
			'desc' => __('Select product tags where the fields should be displayed.', 'product-addons-custom-fields-booking-for-woocommerce'),
			'attributes' => array(
				'data-conditional-id'     => $prefix . 'enable_display_conditions',
				'data-conditional-value' => wp_json_encode(array('on')),
			)
		),
		array(
			'name' => __('Specific Products', 'product-addons-custom-fields-booking-for-woocommerce'),
			'id'   => $prefix . 'display_condition_products', // Ensure unique ID
			'type' => 'custom_multiselect2',
			'options_cb' => 'paocfbfw_get_products_options',
			'desc' => __('Search and select specific products where the fields should be displayed.', 'product-addons-custom-fields-booking-for-woocommerce'),
			'attributes' => array(
				'data-conditional-id'     => $prefix . 'enable_display_conditions',
				'data-conditional-value' => wp_json_encode(array('on')),
			)
		),
		array(
			'name' => __('User Roles', 'product-addons-custom-fields-booking-for-woocommerce'),
			'id'   => $prefix . 'display_condition_user_roles', // Ensure unique ID
			'type' => 'custom_multiselect2',
			'options' => wp_roles()->get_names(), // Get all WordPress user roles
			'desc' => __('Select user roles for which the fields should be displayed.', 'product-addons-custom-fields-booking-for-woocommerce'),
			'attributes' => array(
				'data-conditional-id'     => $prefix . 'enable_display_conditions',
				'data-conditional-value' => wp_json_encode(array('on')),
			)
		),
	),
);


// Set tabs
$cmb->add_field(array(
	'id'   => '__tabs',
	'type' => 'tabs',
	'tabs' => $tabs_setting
));
