(function($) {
    'use strict';

    // Initialize Select2 on page load
    $(document).ready(function() {
        initSelect2();
    });

    function initSelect2() {
        // Multi-select fields
        $('.custom-select2-multi').each(function() {
            var $select = $(this);
            
            // Destroy if already initialized
            if ($select.hasClass('select2-hidden-accessible')) {
                $select.select2('destroy');
            }
            
            // Initialize Select2
            $select.select2({
                width: '100%',
                placeholder: $select.data('placeholder') || ''
            });
            
            // Keep selected items at bottom when selecting (like alt-manager)
            $select.on("select2:select", function (evt) {
                var element = evt.params.data.element;
                var $element = $(element);
                
                $element.detach();
                $select.append($element);
                $select.trigger("change");
            });
        });
    }

    // Re-initialize when CMB2 adds new rows
    if (typeof jQuery !== 'undefined') {
        $(document).on('cmb2_add_row', function(event, newRow) {
            initSelect2();
        });

        $('.cmb-repeatable-group').on('cmb2_add_row', function(event, newRow) {
            initSelect2();
        });
    }

})(jQuery);

