jQuery(document).ready(function ($) {

    //text_url validation
    function isValidURL(url) {
        // Simple regex for demonstration, adjust as needed
        var pattern = /^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w\.-]*)*\/?$/i;
        return pattern.test(url);
    }

    function toggleAddToCart(valid) {
        var btn = $('button.single_add_to_cart_button');
        if (valid) {
            btn.prop('disabled', false);
        } else {
            btn.prop('disabled', true);
        }
    }

    // On input, validate URL
    $(document).on('input', '.paocfbfw-url-field', function() {
        var val = $(this).val();
        var valid = isValidURL(val);
        if (!valid && val.length > 0) {
            $(this).css('border-color', 'red');
        } else {
            $(this).css('border-color', '');
        }
        toggleAddToCart(valid || val.length === 0); // Allow empty if not required
    });

    // On page load, disable Add to Cart if field is required and empty
    $('.paocfbfw-url-field[required]').each(function() {
        if (!isValidURL($(this).val())) {
            toggleAddToCart(false);
        }
    });
    // end text_url validation

    // Datepicker initialization
    

//handle price change on date selection

// Try to get the price from the <ins> tag if it exists, otherwise fall back to the regular price
let originalBasePrice = parseFloat($('.price ins .woocommerce-Price-amount').first().text().replace(/[^0-9.-]+/g, ''));

// If there's no price in <ins>, fall back to the regular price
if (isNaN(originalBasePrice)) {
    originalBasePrice = parseFloat($('.price .woocommerce-Price-amount').first().text().replace(/[^0-9.-]+/g, ''));
}

let totalAddons = 0;

$(document).on('change', '.paocfbfw-price-field[data-price]', function() {
    let $checkbox = $(this);
    let addonPrice = parseFloat($checkbox.data('price')) || 0;

    // console.log('Addon Price:', addonPrice);
    // Add or subtract the addon price from total
    totalAddons = $checkbox.is(':checked') ? 
        totalAddons + addonPrice : 
        totalAddons - addonPrice;

    // Calculate final price
    let finalPrice = originalBasePrice + totalAddons;
    // Update the price display in the <ins> tag if it exists
    if ($('.summary .price ins').length > 0) {
        $('.summary .price ins .woocommerce-Price-amount bdi').html(
            '<span class="woocommerce-Price-currencySymbol">$</span>' + finalPrice.toFixed(2)
        );
    } else {
        // If there's no <ins>, update the regular price
        $('.summary .price .woocommerce-Price-amount bdi').html(
            '<span class="woocommerce-Price-currencySymbol">$</span>' + finalPrice.toFixed(2)
        );
    }
});

});
