<?php
/**
 * Plugin Deactivation Handler - ENVATO COMPLIANT
 * 
 * @package PriceWise_Calculator_Pro
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

class PWCP_Deactivator {
    
    public static function pwcp_deactivate() {
        // Clear scheduled events
        self::pwcp_clear_scheduled_events();
        
        // Clear transients and temporary data
        self::pwcp_clear_temporary_data();
        
        // Clear cache
        self::pwcp_clear_cache();
        
        // Set deactivation timestamp
        update_option('pwcp_deactivation_time', current_time('timestamp'));
        
        // Fire deactivation hook
        do_action('pwcp_deactivated');
    }
    
    private static function pwcp_clear_scheduled_events() {
        $scheduled_events = array(
            'pwcp_daily_cleanup',
            'pwcp_weekly_analytics_cleanup',
            'pwcp_monthly_report',
            'pwcp_cache_refresh'
        );
        
        foreach ($scheduled_events as $event) {
            wp_clear_scheduled_hook($event);
        }
    }
    
    private static function pwcp_clear_temporary_data() {
        global $wpdb;
        
        // Clear transients
        $transients = array(
            'pwcp_calculator_cache',
            'pwcp_field_validation_cache',
            'pwcp_analytics_cache',
            'pwcp_system_info_cache'
        );
        
        foreach ($transients as $transient) {
            delete_transient($transient);
        }
        
        // Clear all plugin transients - FIXED: Now using $wpdb->prepare()
        $table = $wpdb->options;
        $like1 = $wpdb->esc_like('_transient_pwcp_') . '%';
        $like2 = $wpdb->esc_like('_transient_timeout_pwcp_') . '%';
        
        $wpdb->query(
            $wpdb->prepare(
                "DELETE FROM {$table} WHERE option_name LIKE %s OR option_name LIKE %s",
                $like1,
                $like2
            )
        );
    }
    
    private static function pwcp_clear_cache() {
        wp_cache_flush();
        flush_rewrite_rules();
    }
}