/**
 * Delete Warning Handler 

 * @package PriceWise_Calculator_Pro
 * @since 1.0.0
 */

(function($) {
    'use strict';
    
    $(document).ready(function() {
        
        /**
         * Handle delete link click
         * Shows warning about data deletion based on user's saved preference
         */
        $('#the-list')
            .off('click.pwcp', 'tr[data-slug="pricewise-calculator-pro"] .delete a')
            .on('click.pwcp', 'tr[data-slug="pricewise-calculator-pro"] .delete a', function(e) {
                e.preventDefault();
                
                // Check if localized data is available
                if (!window.pwcpDeleteWarning) {
                    return;
                }
                
                var deleteUrl = $(this).attr('href');
                
                // Build confirmation message from localized strings
                var confirmMessage = pwcpDeleteWarning.warningMessage + '\n\n' + 
                                   pwcpDeleteWarning.settingsLink;
                
                // Show confirmation dialog
                var confirmDelete = confirm(confirmMessage);
                
                if (confirmDelete) {
                    // User confirmed - proceed with deletion
                    window.location.href = deleteUrl;
                } else {
                    // User cancelled - offer to visit settings page
                    var goToSettings = confirm(pwcpDeleteWarning.goToSettings);
                    
                    if (goToSettings && pwcpDeleteWarning.settingsUrl) {
                        window.location.href = pwcpDeleteWarning.settingsUrl;
                    }
                }
            });
        
        /**
         * Handle deactivate link 
         * Currently allows normal deactivation without interruption
         * Can be customized if you need to show a message on deactivation
         */
        $('#the-list')
            .off('click.pwcp-deactivate', 'tr[data-slug="pricewise-calculator-pro"] .deactivate a')
            .on('click.pwcp-deactivate', 'tr[data-slug="pricewise-calculator-pro"] .deactivate a', function(e) {
                // Deactivation proceeds normally - no data is deleted on deactivation
                // This handler is here as a placeholder if you need custom deactivation logic
            });
            
    });
    
})(jQuery);