/**
 * Category Assignment (FREE VERSION - DISABLED)
 * @package PriceWise_Calculator_Pro
 * @since 1.0.0
 */

(function($) {
    'use strict';
    
    /**
     * Initialize category assignment functionality
     */
    function initCategoryAssignment() {
        // Category assignment disabled in free version
        // Remove category assignment option from UI
        $('input[name="calculator_type"][value="category"]').prop('disabled', true);
        $('.pwcp-strategy-card').has('input[value="category"]').css('opacity', '0.5');
        
        // Show premium notice if category section exists
        var $categorySection = $('#pwcp-category-assignment-section');
        if ($categorySection.length) {
            $categorySection.html(
                '<div style="text-align: center; padding: 40px 20px; background: #f8f9fa; border: 2px dashed #dee2e6; border-radius: 8px;">' +
                    '<svg style="width: 48px; height: 48px; color: #6c757d; margin-bottom: 15px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">' +
                        '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>' +
                    '</svg>' +
                    '<h3 style="margin: 0 0 10px 0; font-size: 20px; color: #212529;">Category Assignment</h3>' +
                    '<p style="margin: 0 0 20px 0; color: #6c757d; font-size: 14px;">This feature is available in the premium version.</p>' +
                    '<a href="https://devtonicstudios.com" target="_blank" class="button button-primary" style="background: #667eea; border-color: #667eea;">Purchase Premium Version</a>' +
                '</div>'
            );
        }
    }
    
    // Initialize when DOM is ready
    $(document).ready(function() {
        initCategoryAssignment();
    });
    
})(jQuery);