/**
 * Admin Notices Handler - AJAX Dismissal
 * 
 * @package PriceWise_Calculator_Pro
 * @since 1.0.0
 */

(function($) {
    'use strict';
    
    $(document).ready(function() {
        
        /**
         * Handle dismissal when user clicks the "X" button
         * This ensures the notice stays dismissed permanently
         */
        $(document).on('click', '.pwcp-uninstall-notice .notice-dismiss', function() {
            // Check if AJAX data is available
            if (!window.pwcpNoticeAjax) {
                return;
            }
            
            // Send AJAX request to persist dismissal
            $.post(pwcpNoticeAjax.ajaxUrl, {
                action: 'pwcp_dismiss_uninstall_notice',
                _ajax_nonce: pwcpNoticeAjax.nonce
            }, function(response) {
                // Optional: Handle response if needed
                if (response.success) {
                    // Notice successfully dismissed
                }
            }).fail(function(xhr, status, error) {
                // Optional: Handle error
            });
        });
        
    });
    
})(jQuery);