<?php
/** 
 * Shows warning on plugins page before deletion
 * 
 * @package PriceWise_Calculator_Pro
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

class PWCP_Delete_Warning {
    
    public function __construct() {
        add_action('admin_enqueue_scripts', array($this, 'enqueue_delete_warning_script'));
    }
    
    /**
     * Enqueue JavaScript warning before deletion
     * Only loads on plugins.php screen
     */
    public function enqueue_delete_warning_script($hook) {
        // Only load on plugins page
        if ($hook !== 'plugins.php') {
            return;
        }
        
        $preference = get_option('pwcp_uninstall_delete_data', 'not_set');
        
        if ($preference === 'not_set') {
            $message = __('⚠️ IMPORTANT: You haven\'t set your data preference for PriceWise Calculator Pro.\n\nBy default, your data will be PRESERVED.\n\nTo choose what happens to your data, click "Uninstall Settings" first.', 'pricewise-calculator-pro');
        } elseif ($preference === 'yes') {
            $message = __('⚠️ WARNING: You chose to DELETE ALL DATA.\n\nAll calculators, settings, and calculations will be permanently removed.\n\nAre you absolutely sure?', 'pricewise-calculator-pro');
        } else {
            $message = __('Your data will be preserved and available if you reinstall.\n\nProceed with uninstall?', 'pricewise-calculator-pro');
        }
        
        // Enqueue the JavaScript file
        wp_enqueue_script(
            'pwcp-delete-warning',
            plugin_dir_url(__FILE__) . 'assets/js/delete-warning.js',
            array('jquery'),
            '1.0.0',
            true
        );
        
        // Pass data to JavaScript
        wp_localize_script(
            'pwcp-delete-warning',
            'pwcpDeleteWarning',
            array(
                'pluginBasename' => PWCP_PLUGIN_BASENAME,
                'message' => $message
            )
        );
    }
}

new PWCP_Delete_Warning();