# Changelog

All notable changes to PriceWise Calculator Pro will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.0] - 2025-01-27

### Added - FREE Version
- Initial FREE release of PriceWise Calculator Pro
- Tabbed calculator builder interface with four main sections:
  - Basic Tab: Calculator name, description, and assignment strategy
  - Formula Tab: Pricing formulas and calculation setup
  - Fields Tab: Add and configure input fields
  - Settings Tab: Publication status, priority, and display options
- Number input fields with min/max validation
- Global assignment strategy (automatically applies to all WooCommerce products)
- Custom formula engine for calculations
- Live price calculation and real-time updates
- WooCommerce seamless integration
- WooCommerce cart integration with custom pricing
- Admin dashboard with overview
- Field manager with validation rules
- Database optimization and caching
- Security features:
  - Nonce verification
  - Capability checks
  - Input sanitization
  - SQL injection prevention
- Translation ready with .pot file
- Responsive design for all devices
- Calculation logging system
- Uninstall data management with user consent
- System requirements checker
- Admin notices system
- Enhanced field validation
- Search and filter calculators
- Grid view and list view toggle for calculator management

### Premium Features (Not Included in Free Version)
- Additional field types:
  - Text input fields
  - Dropdown select fields
  - Checkbox fields
  - Radio button fields
  - Slider fields
  - Textarea fields
  - File upload fields
- Product-specific assignment (assigned to specific products)
- Category assignment (automatically applied to entire categories)
- Multi-step calculator support with NEXT/PREV navigation
- Modern slider-based frontend interface with step-by-step navigation
- Progress tracking for multi-step calculators (e.g., "1 of 5")
- Export/Import functionality for calculators
- Settings panel with extensive customization options:
  - 15+ color customization controls
  - Enhanced color picker (visual + hex input)
  - Layout options
  - Display preferences
- Analytics tracking (optional)
- Auto-save functionality
- Calculator duplication feature
- Bulk actions support

[Upgrade to Premium](https://devtonicstudios.com) to unlock all features.

### Security
- Implemented WordPress security best practices
- Added nonce verification for all forms
- Input sanitization for all user inputs
- Output escaping for all displayed data
- SQL injection prevention using $wpdb->prepare()
- Capability checks for admin functions
- CSRF protection
- XSS prevention

### Performance
- Database query optimization
- Caching system for calculations
- Lazy loading for admin assets
- Efficient AJAX handling
- Database indexing

### Developer Features
- Multiple hooks and filters for extensibility
- Template override system
- Well-documented code
- PSR-4 autoloading compatible structure
- Action and filter hooks
- Developer-friendly API

### Free Version Experience
- Clean tabbed interface for easy navigation
- Intuitive field addition with "Add Field" button
- Visual feedback for required vs. optional fields
- Formula validation with helpful error messages
- Calculator status toggle (Active/Inactive)
- Priority system for multiple calculators
- Quick edit actions

---

## [Unreleased]

### Planned Premium Features
- Conditional logic for fields
- Advanced formula builder with GUI
- Email notification system
- PDF quote generation
- Advanced analytics and reporting
- Integration with popular form plugins
- API for third-party integrations
- Custom field types API
- Calculator templates library
- A/B testing for calculators
- Copy-to-clipboard for formulas
- Keyboard shortcuts in builder

---

## Release Notes

### Version 1.0.0 - FREE Release
This is the first stable FREE release of PriceWise Calculator Pro. The free version provides everything you need to create basic number-based calculators with global assignment.

**Free Version Highlights:**
- Professional tabbed calculator builder
- Number input fields with validation
- Custom pricing formula engine
- Global assignment to all WooCommerce products
- Real-time price calculations
- Mobile responsive design
- Translation ready
- Secure and optimized

**Premium Version Highlights:**
- All field types (text, dropdown, radio, checkbox, slider, file, textarea)
- Product-specific assignment
- Category assignment
- Multi-step slider interface
- 15+ color customization controls
- Export/Import functionality
- Priority support

**Admin Interface:**
Build calculators using a clean tabbed interface:
1. Basic Tab - Name, description, assignment
2. Formula Tab - Pricing calculations
3. Fields Tab - Add number input fields
4. Settings Tab - Publication & display options

**Customer Interface (Free Version):**
Customers see a functional calculator interface where they can input numbers, see real-time price updates, and add to cart with custom pricing.

**Customer Interface (Premium Version):**
Premium users get a beautiful slider-based calculator that guides customers step-by-step through the configuration process with progress tracking and enhanced UX.

**Requirements:**
- WordPress 5.8 or higher
- PHP 7.4 or higher
- WooCommerce 5.0 or higher (recommended)
- MySQL 5.6 or higher

**Critical Setup Requirements:**
- Calculators must have at least 1 field to display on frontend
- WooCommerce products must have a regular price set
- Calculator status must be set to "Active"

**Documentation:**
Complete documentation, tutorials, and guides are available at:
https://devtonicstudios.com/documentation/

---

## Support

For support, documentation, and updates:
- **Full Documentation:** https://devtonicstudios.com/documentation/
- **Website:** https://devtonicstudios.com
- **Support:** Contact through our website
- **Upgrade to Premium:** https://devtonicstudios.com/upgrade

---

## License

PriceWise Calculator Pro is licensed under GPL v2 or later.