<?php
/**
*
* Auto Load Output
*
*/

if (!class_exists('PDA_ViewLoader')) {
    class PDA_ViewLoader
    {
        public static function render_custom_column($post_id)
        {
            $repo = new PDA_v3_Gold_Repository;
            $is_protected_file = $repo->is_protected_file($post_id);
            $pda_class = $is_protected_file ? '' : PDA_v3_Constants::PDA_V3_CLASS_FOR_FILE_UNPROTECTED;
            $pda_text = $is_protected_file ? PDA_v3_Constants::PDA_V3_FILE_PROTECTED : PDA_v3_Constants::PDA_V3_FILE_UNPROTECTED;
            $title_text = $is_protected_file ? PDA_v3_Constants::PDA_V3_TITLE_FOR_FILE_PROTECTED : PDA_v3_Constants::PDA_V3_TITLE_FOR_FILE_UNPROTECTED;
            $pda_icon = $is_protected_file ? '<i class="fa fa-check-circle" aria-hidden="true"></i>' : '<i class="fa fa-times-circle" aria-hidden="true"></i>';
            ?>
            
            <div id="pda-v3-column_<?php echo esc_attr( $post_id ); ?>" class="pda-gold-v3-tools">
                <p id="pda-v3-wrap-status_<?php echo esc_attr( $post_id ); ?>">
                    <span id="pda-v3-text_<?php echo esc_attr( $post_id ); ?>" class="protection-status <?php echo esc_attr( $pda_class ); ?>" title="<?php echo esc_attr( $title_text ); ?>">
                        <?php echo $pda_icon; ?>
                        <?php echo esc_html( $pda_text ); ?>
                    </span>
                    <?php do_action( PDA_Private_Hooks::PDA_HOOK_SHOW_STATUS_FILE_IN_PDA_COLUMN, $post_id ); ?>
                </p>
                <div>
                    <a class="pda_gold_btn" id="pda_gold-<?php echo $post_id?>"><?php echo esc_html__( 'Configure file protection', 'prevent-direct-access' ) ?></a>
                </div>
            </div>
            <?php
        }

        public static function render_helpers()
        {
            $home_path = get_home_path();
            global $is_apache;
            if ($is_apache) {
                $btn_name = Pda_Gold_Functions::is_fully_activated() ? "Check .htaccess file" : "Check .htaccess files";
                $open_message = "If your .htaccess file were writable, Prevent Direct Access Gold could do this automatically, ";
                $end_message = "but it isn’t so these are the mod_rewrite rules you should have in your .htaccess to start protecting your files. Click in the field and press CTRL + a to select all.";
            } else {
                $btn_name = "Check rewrite rules";
                $open_message = "It looks like you’re using Ngnix webserver. Since Nginx does not have .htaccess-type capability, ";
                $end_message = "Prevent Direct Access Gold cannot update your server configuration automatically for you. Here’s how you can do it manually:";
            } ?>
            <div class="main_container">
                <?php if (!Pda_Gold_Functions::is_fully_activated()) : ?>
                <p>
                    <?php

                    esc_html_e($open_message, 'prevent-direct-access');

            if (! is_writable($home_path . '.htaccess')) {
                $errors['Nonwritable'] = sprintf(esc_html__('the site\'s %s file is not writable', 'as in: "the site\'s .htaccess file is not writable "', 'prevent-direct-access'), '<code>.htaccess</code>');
            }

            $err_txt = '';

            if (isset($errors)) {
                $last = array_pop($errors);
                if (count($errors) > 0) {
                    $err_txt .= implode(', ', $errors) . ' ' . esc_html_('and', 'prevent-direct-access') .  ' ';
                }
                $err_txt .= $last . ',';
            }

            printf(esc_html_x($end_message, 'as in: "Because *you are running WordPress MultiSite* PDA Gold cannot do it automatically"', 'prevent-direct-access'), $err_txt);

            echo ' ';

            echo wp_kses(__('', 'prevent-direct-access'), array( 'strong' => array() ), false); ?>
                </p>
                <ol>
                    <li>
                        <?php if ($is_apache) : ?>
                            <p>
                                <?php
                                $rewrite_file_type = '<code>.htaccess</code>';
            $rewrite_file_loc  = '<code>' . $home_path . '</code>';
            $rewrite_rule_loc  = sprintf(wp_kses(__('<strong>in the WordPress rewrite block</strong> (the WordPress block usually starts with %s and ends with %s, <strong>just below</strong> the line reading %s', 'prevent-direct-access'), array( 'strong' => array() ), false), '<code># BEGIN WordPress</code>', '<code># END WordPress</code>', '<code>RewriteRule ^index\.php$ - [L]</code>');

            if (! is_multisite() && ! get_option('permalink_structure')) {
                $rewrite_rule_loc = __('<strong>above</strong> any other rewrite rules in the file.', 'prevent-direct-access');

                printf(wp_kses(__('PDA Gold works best with %s enabled, so it is strongly recommended that you %s! If, however, you really <i>really</i> want to use ugly permalinks, then...', 'prevent-direct-access'), array( 'i' => array() ), false), '<a href="http://codex.wordpress.org/Introduction_to_Blogging#Pretty_Permalinks" target="_blank">' . esc_html__('Pretty Permalinks', 'prevent-direct-access') . '</a>', '<a href="http://codex.wordpress.org/Using_Permalinks" target="_blank">' . esc_html__('enable them', 'prevent-direct-access') . '</a>');
                echo "\n";
            }
            printf(esc_html__('Add the following rules to your %s file located at %s', 'prevent-direct-access'), $rewrite_file_type, $rewrite_file_loc);
            echo ' ', $rewrite_rule_loc; ?>
                                <?php $rules = Prevent_Direct_Access_Gold_Htaccess::get_the_rewrite_rules(); ?>
                            </p>
                        <?php else : ?>
                            <p>
                                Update our rewrite rules on your Ngnix server <a target="_blank" href="https://preventdirectaccess.com/docs/nginx-support/">as per this instructions</a>
                            </p>
	                        <?php $rules = Prevent_Direct_Access_Gold_Htaccess::get_nginx_rules(); ?>
                        <?php endif; ?>
                        <textarea class="code" readonly="readonly" cols="90" rows="<?php echo count($rules); ?>"><?php echo esc_textarea(implode("\n", $rules)); ?></textarea>
                    </li>
                    <li>
                        <p>
                            <?php esc_html_e('Once done, please click on the button below to check if the rewrite rules are inserted correctly', 'prevent-direct-access'); ?>
                        </p>
                        <form method="post" id="enable_pda_v3_form">
                            <?php wp_nonce_field('pda_ajax_nonce_v3', 'nonce_pda_v3'); ?>
                            <?php submit_button(__($btn_name, 'prevent-direct-access'), 'primary', 'enable_pda_v3', false); ?>
                        </form>
                    </li>
                </ol>
                <p>
                    Or using raw redirect URL
                    <div>
                        <form method="post" id="enable_pda_v3_raw_url">
			                <?php wp_nonce_field('pda_ajax_nonce_v3', 'nonce_pda_v3'); ?>
			                <?php submit_button(__('Use raw redirect URL', 'prevent-direct-access'), 'primary', 'enable_raw_url', false); ?>
                        </form>
                    </div>
                </p>
                <?php else: ?>
	                <?php if ($is_apache) : ?>
                        <p>
			                <?php
                            $rewrite_file_type = '<code>.htaccess</code>';
            $rewrite_file_loc  = '<code>' . $home_path . '</code>';
            $rewrite_rule_loc  = sprintf(wp_kses(__('<strong>within your WordPress rewrite block</strong>, which usually starts with %s and ends with %s, and <strong>just below</strong> the line reading %s', 'prevent-direct-access'), array( 'strong' => array() ), false), '<code># BEGIN WordPress</code>', '<code># END WordPress</code>', '<code>RewriteRule ^index\.php$ - [L]</code>');

            if (! is_multisite() && ! get_option('permalink_structure')) {
                $rewrite_rule_loc = __('<strong>above</strong> any other rewrite rules in the file.', 'prevent-direct-access');

                printf(wp_kses(__('PDA Gold works best with %s enabled, so it is strongly recommended that you %s! If, however, you really <i>really</i> want to use ugly permalinks, then...', 'prevent-direct-access'), array( 'i' => array() ), false), '<a href="http://codex.wordpress.org/Introduction_to_Blogging#Pretty_Permalinks" target="_blank">' . esc_html__('Pretty Permalinks', 'prevent-direct-access') . '</a>', '<a href="http://codex.wordpress.org/Using_Permalinks" target="_blank">' . esc_html__('enable them', 'prevent-direct-access') . '</a>');
                echo "\n";
            }
            printf(esc_html__('If the original links of your protected files are still accessible and/or their private links don\'t work, please make sure our rewrite rules are inserted correctly on your .htaccess file by clicking on the button below.', 'prevent-direct-access'), $rewrite_file_type, $rewrite_file_loc);
            echo "<p>";
            printf(esc_html__('The following rules should be added into your %s file located at %s', 'prevent-direct-access'), $rewrite_file_type, $rewrite_file_loc);
            echo ' ', $rewrite_rule_loc, "</p>"; ?>
			                <?php $rules = Prevent_Direct_Access_Gold_Htaccess::get_the_rewrite_rules(); ?>
                            <textarea class="code" readonly="readonly" cols="90" rows="<?php echo count( $rules ); ?>"><?php echo esc_textarea( implode( "\n", $rules ) ); ?></textarea>
                        </p>
                    <?php elseif( self::is_server( 'microsoft-iis' ) ) : ?>
                        <p>
                            <a target="_blank" href="https://preventdirectaccess.com/docs/prevent-direct-access-lite/#IIS">Guides for Microsoft IIS server!</a>
                        </p>
		                <?php $rules = Prevent_Direct_Access_Gold_Htaccess::get_iis_rules(); ?>
                        <textarea class="code" readonly="readonly" cols="90" rows="<?php echo count( $rules ); ?>"><?php echo esc_textarea( implode( "\n", $rules ) ); ?></textarea>
	                <?php elseif( self::is_server( 'nginx'  ) ) : ?>
                        <p>
                            Update our rewrite rules on your Ngnix server <a target="_blank" href="https://preventdirectaccess.com/docs/nginx-support/">as per this instructions</a>
                        </p>
		                <?php $rules = Prevent_Direct_Access_Gold_Htaccess::get_nginx_rules(); ?>
                        <textarea class="code" readonly="readonly" cols="90" rows="<?php echo count( $rules ); ?>"><?php echo esc_textarea( implode( "\n", $rules ) ); ?></textarea>
	                <?php endif; ?>
                    <p>
                        <form method="post" id="enable_pda_v3_form_no_reload">
		                    <?php wp_nonce_field( 'pda_ajax_nonce_v3', 'nonce_pda_v3' ); ?>
		                    <?php submit_button( __( $btn_name, 'prevent-direct-access' ), 'primary', 'enable_pda_v3', false ); ?>
                        </form>
                    </p>
                <?php endif ?>
            </div>
		    <?php
	    }

	    public static function is_server( $server ) {
		    $server_info = isset( $_SERVER['SERVER_SOFTWARE'] ) ?  wp_unslash( $_SERVER['SERVER_SOFTWARE'] )  : '';
		    return strpos( strtolower( $server_info ), $server ) !== false;
	    }

	    public static function render_iis_server() {

	    }
    }


}
