<?php
   /**
	* "Preciso Bid-Smart Advertising" is free
	* software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* "Preciso Bid-Smart Advertising" is distributed
	* in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with "Preciso Bid-Smart Advertising".
	* If not, see <https://www.gnu.org/licenses/>.
	* php version 7.2.10
	*
	* @package Preciso_Bid_Smart_Advertising
	* @link    Preciso
	* @return  Preciso
	*/

?>

<div class="terms">
  <div class="l-header">
	<div class="logo-2"></div>
	<div class="clear"></div>
  </div>
  <div class="right-content" style="background-color:#fff">
	<div class="terms-inner content-box" style="text-align:center">
	  <div class="loader api-loader"></div>
	  <h1>Terms & Conditions</h1>
	</div>
	<div class="terms-inner" style="background-image: url(<?php echo esc_url( PRECISO_PLUGIN_DIR ); ?>assets/images/preciso_ico_big.png);
	background-size: 400px; background-position: 88% 20%; background-repeat: no-repeat;">
	  <div style=" background-color: rgba(255,255,255,.85); max-width:100%;padding:30px; margin:0 auto">
		<h2><u>Advertiser Terms</u></h2>
		<p>This <strong>GENERAL TERMS AND CONDITIONS</strong> (collectively with any
		  and all Insertion Order and/or Order Form addendums, exhibits, premises,
		  schedules, and/or appendixes hereto, and 
		  as each of the same may be amended,
		  supplemented or otherwise modified from time 
		  to time, this “<strong>Agreement</strong>”),
		  are made by and entered into between Preciso S.r.l. a corporation having
		  its registered office located at Piazza Alessandrini n.25, 65127, Pescara,
		  Italy (“<strong>Preciso</strong>”), and the other entity signatory hereto
		  (on its own behalf and on behalf of its Affiliates, 
		  “<strong>Advertiser</strong>”).
		  Preciso and Advertiser may be referred to 
		  herein together as the “<strong>Parties</strong>”,
		  and each may be referred to herein as a “<strong>Party</strong>”.</p>
		<p><strong>WHEREAS</strong>, Preciso is a 
		  company expert in display advertising
		  and retargeting, proficiently accomplished 
		  through a programmatic understanding,
		  and Preciso owns a proprietary technology used to optimise programmatic
		  buying called “<strong>Preciso</strong>” (as more precisely defined below);
		  and</p>
		<p><strong>WHEREAS</strong>, 
		  the Advertiser wants to use the Services as provided
		  in this Agreement;</p>
		<p><strong>NOW, THEREFORE</strong>, in consideration of the mutual promises
		  set forth in this Agreement, the Parties, intending to be legally bound,
		  agree as follows:</p>
		<h1>1. Definitions.</h1>
		<p>“<strong>Ad</strong>” means any Advertiser’s advertising that is targeted
		  to an end user through the Services.</p>
		<p>“<strong>Affiliate</strong>” means, with 
		  respect to a party, an entity that
		  directly or indirectly controls, is 
		  controlled by or is under common control
		  with such party.</p>
		<p> “<strong>Data Protection Laws</strong>” 
		  means, the EU General Data Protection
		  Regulation 2016/679 (“<strong>GDPR</strong>”), 
		  as well as any other personal
		  data protection legislation applicable, already in force or that will enter
		  into force after this DPA enters into force, including the provisions of
		  any Data Protection Authority. Each of the respective terms 
		  “<strong>data controller</strong>”,
		  “<strong>data processor</strong>”, 
		  “<strong>data subject</strong>”, 
		  “<strong>personal data</strong>”,
		  and “<strong>processing</strong>” shall have the same meaning as in Data
		  Protection Laws, and their cognate 
		  terms shall be construed accordingly.</p>
		<p>“<strong>Effective Date</strong>” means the execution date of an Insertion
		  Order and/or any date otherwise indicated by the Parties in writing, and/or
		  in absence of the above, the starting 
		  date of the provision of the Services.</p>
		<p>“<strong>Fees</strong>” means the amount that the Advertiser shall pay to
		  Preciso for the Services, as stated under Section 5.</p>
		<p>“<strong>Inventory</strong>” means Publisher’s advertising spaces on the
		  Sites made available for purchase.</p>
		<p>“<strong>Insertion Order</strong>” or “<strong>Order Form</strong>” means
		  a document executed by both Parties that specifies the type of Services
		  to be provided to Advertiser by Preciso for campaigns, the duration of the
		  Services, a budget, fees, and other specific details for the Services.</p>
		<p>“<strong>Preciso</strong>” means Preciso proprietary 
		  DSP technology, licensed
		  to the Advertiser which allows the Advertiser 
		  to plan directly its campaigns.</p>
		<p> “<strong>Preciso Cookie(s)</strong>” 
		  means all the identifiers necessary for
		  the performance of the Services, and all data 
		  which may be collected through
		  the Ad by Preciso, as from time to time indicated 
		  in Preciso’s privacy policy,
		  made available here 
		 <a href="https://preciso.net/privacy/"> https://preciso.net/privacy/  </a> 
	   </p>
		<p>“<strong>Publisher</strong>” 
			means the owners of the Sites where the Ad will
		  be displayed with the Services.</p>
		<p>“<strong>Reasonable Endeavours</strong>” 
			means taking such steps and performing
		  in such a manner, including, without limitation, by reference to the levels
		  of accuracy, quality, care, prudence, 
		  completeness, timeliness, responsiveness,
		  resource efficiency, productivity and proactive 
		  monitoring of service performance,
		  as a well-managed Preciso would undertake and perform where such Preciso
		  was acting in a diligent, prudent and 
		  reasonable manner to achieve a particular
		  desired result for its own benefit.</p>
		<p>“<strong>Rules</strong>” means, collectively, all now 
		  existing or hereinafter
		  enacted or amended laws, rules, regulations, self-regulations,
		  declarations,
		  decrees, directives, statutes, and/or other enactments, orders, mandates
		  or resolutions issued or enacted by any governmental or regulatory entity
		  (including, without limitation, any domestic or foreign, supra-national,
		  state, county, municipal, local, territorial or other government), which
		  includes, to the extent applicable and without 
		  limitation, Directive 95/46/EC,
		  Directive 2002/58/EC, European Commission decisions and guidance, each
		  as may be transposed into domestic legislation of each European Member
		  State or other country and as amended, replaced or superseded from time
		  to time, including, without limitation, by Data Protection Laws and laws
		  implementing or supplementing Data Protection Laws,
		  and any and all applicable
		  self-regulatory codes and principles related to privacy, the processing
		  or protection of personal data, advertising, marketing or the interception,
		  recording or monitoring of communications.</p>
		<p>“<strong>Services</strong>” 
		  means any service that Preciso offering to Advertiser,
		  that Advertiser agrees to receive, subject to this Agreement, as provided
		  for in the Insertion Order(s) If specified within the Insertion Order,
		  they may include Preciso’s license.</p>
		<p> “<strong>Site</strong>”
		 means a website, application, or other digital property
		  on or in which Preciso shall provide the Services, owned or legitimately
		  managed by Publishers.</p>
		<h1><a name="_Toc529199544"></a>2. Scope and Structure of Agreement.</h1>
		<h2><a name="_Toc529199545"></a>
			<strong>2.1 Scope of the Services.</strong>
		</h2>
		<p>Preciso reserves the right, at its sole discretion, to display Ad through
		  online advertising campaigns within Preciso’s network, which will include
		  multiple traffic sources, promotional models, and Sites. For the execution
		  of the Services, Advertiser grants Preciso (i) 
		  the right to select and display
		  Ad within the Advertiser properties, (ii) to promote, market and sell to
		  third party Advertisers and any agencies, (iii) to monitor and track the
		  use of an Ad and to analyse any relevant information, as well as (iv) to
		  do any ancillary and additional activity of the above. Subject to the terms
		  and conditions of this Agreement, Advertiser shall have a non-exclusive
		  right to use the Services during the Term. If the 
		  Services include Preciso’s
		  license, Preciso will grant the Advertiser an access to a 
		  dedicated dashboard
		  where the Advertiser may directly plan its advertising campaigns and a
		  license to use Preciso for the time indicated in the Insertion Order.</p>
		<h2><a name="_Toc529199546"></a>
			<strong>2.2 Agreement Structure</strong>.
		</h2>
		<p>This Agreement applies to and governs each Party’s participation in, and
		  respective rights and obligations with respect to, the provision of the
		  Services. The obligations of the Parties set forth in this Agreement are
		  minimum obligations and are not intended to replace or limit any other
		  obligations to which a Party may otherwise be subject, including, without
		  limitation, obligations under applicable Rules. These General Terms and
		  Conditions shall be read and construed in conjunction with the Insertion
		  Order signed between the Parties and without prejudice to any subsequent
		  amendment or modification of any particular provision contained herein,
		  shall become effective and binding as from date of
		  signature of the Insertion
		  Order. In the event of any conflict with any specific term or agreement
		  reached between the Parties on the Insertion Order, the terms or agreement
		  specified in the Insertion Order shall prevail.</p>
		<h2><a name="_Toc529199547"></a>
			<strong>2.3 Unilateral Amendments.</strong>
		</h2>
		<p>Notwithstanding anything to the contrary in this Agreement, but subject to
		  Advertiser’s rights under Section 6.4 hereof, Preciso may supplement, amend,
		  or otherwise modify the terms and conditions of this Agreement (i) due
		  to a change in (including, without limitation, addition of) Rule(s) and/or
		  (ii) in order to optimize the adoption, implementation, and/or operation
		  of the Services, as determined by Preciso in 
		  its reasonable discretion (each,
		  a “<strong>Unilateral Amendment</strong>”),
		   in each case upon notice to
		  Advertiser; provided that Preciso shall apply the terms of 
		  each such Unilateral
		  Amendment to its corresponding agreement with each other similarly situated
		  (e.g., in the same category(ies) and jurisdiction) Advertisers.</p>
		<p> </p>
		<h1><a name="_Toc529199548"></a>
		3. Representations, Warranties and Obligations</h1>
		<h2><a name="_Toc529199549"></a>
			<strong>3.1 General Representations and Warranties.</strong>
		</h2>
		<p>Each Party represents and warrants that:
		 (i) it has and will have all necessary
		  rights and authority to enter into, and to perform its obligations under,
		  this Agreement; and (ii) its performance under this Agreement will not
		  violate any applicable Rule(s) or any other agreement or terms of service
		  to which it is a party or by which it is bound.</p>
		<h2><a name="_Toc529199550"></a><strong>3.2 Security.</strong></h2>
		<p>Without limiting either Party’s obligations 
			under this Agreement, each Party
		  will maintain technical and organisational measures to ensure, appropriate
		  to the nature of its Personal Data, security of 
		  such Personal Data, including,
		  without limitation, protection against unauthorised or unlawful processing
		  and against accidental loss, destruction or damage</p>
		<h2><a name="_Toc529199551"></a>
			<strong>3.3 Advertiser Representations, 
			Warranties, and Obligations.</strong>
		</h2>
		<p>Without limiting the generality of Section 3.1 hereof and without limiting
		  any of Advertiser’s obligations under this Agreement, Advertiser represents
		  and warrants that:</p>
		<ol>
		  <li>all of the information Advertiser has provided and shall in the future
			provide to Preciso is accurate and current.</li>
		  <li>has all necessary and legal rights, powers, and authority to accept and
			be bound, and to bound any subject on his behalf, by these Agreement
			and to perform the acts required of Advertiser hereunder.</li>
		  <li>is in compliance with all applicable laws, Rules, 
			and regulations and with
			Data Protection Laws. For that purpose, Advertiser shall implement all
			necessary measures to ensure compliance.</li>
		  <li>Advertiser represents and warrants to Preciso that: (i) it has the right
			to enter into this Agreement, to grant all rights granted and to perform
			its obligations under this Agreement; (ii) the Ad do not include, and
			does not give access via hyperlinks to any property containing, materials
			that are obscene, defamatory or contrary to any Applicable Law; (iii)
			Ad comply at all times with Rules in all jurisdictions where Ads and
			Sites are viewed; (iv) Ad do not display, reference, link to, or endorse
			any content that violates this Agreement or the Rules; (v) Ad does not
			infringe or misappropriate the rights of any third party; (vi) Ad are
			compliant to any applicable advertising law, 
			including self-regulation.</li>
		  <li>Advertiser is strictly prohibited from effecting any re-arrangements or
			modifications of any kind to tags and content of any Preciso Cookies.
			Failure to comply with this obligation may result in tracking issues
			and relevant payments due from the use of any such 
			modified or re-arranged
			content shall not be guaranteed.</li>
		  <li>Advertiser will comply with all requirements for use of 
			the Services communicated
			by Preciso to Advertiser, and acknowledges that absent such compliance,
			Preciso may be unable to provide the Services to Advertiser. Depending
			on the Services Advertiser chooses to receive, technical requirements
			may include: including tags, pixels, script, or code supplied by Preciso
			on Advertiser's Ad. Preciso will have no liability to Advertiser for such
			inability to provide the Services, if such inability is a 
			result of Advertiser’s
			failure to comply with this Section.</li>
		  <li>Non-solicit. Except in the case of a specific request from Preciso, the
			Company for a period of 2 (two) years shall not solicit or 
			have any direct
			contractual relationship with Publishers introduced by Preciso under this
			Agreement with respect to similar services and/or services competing
			with the Services of Preciso which are the subject of the Agreement.</li>
		</ol>
		<p> </p>
		<h2><a name="_Toc529199552"></a>
			<strong>3.4 If Advertiser is an Agency: Authority, Liability,
			 and Direct Relationship.</strong>
		</h2>
		<p>Where Advertiser is an Agency or authorized reseller entering 
			into this Agreement
		  on behalf of their clients: (i) Agency or authorized reseller represents
		  that it has the authority to act on behalf of such clients with respect
		  to all obligations and representations set forth in this Agreement; (ii)
		  upon request, Agency/authorized reseller will provide Preciso with written
		  confirmation of the relationship between Agency/authorized reseller and
		  its clients (this confirmation should include their clients ’s 
		  acknowledgement
		  that Agency is indeed its agent and is authorized to act on its behalf
		  in connection with the Agreement); (iii) upon the request of Preciso, Agency
		  will provide Preciso with written confirmation that Advertiser has paid
		  to Agency funds sufficient to make payments pursuant to the Agreement;
		  (iv) Agency or authorized reseller accepts responsibility for the actions
		  of its clients and liability for all expenses incurred 
		  through the provision
		  of Services to its clients, and assumes responsibility for
		  ensuring compliance
		  with and breach of this Agreement by its clients; (v) except as otherwise
		  set forth hereunder, Agencies or authorized resellers will ensure 
		  the performance
		  of their respective clients’ obligations under this Agreement and will
		  have joint and several liability in respect of clients’ breach of this
		  Agreement; (vi) Agency or authorized reseller clients may request at any
		  time that their Account be migrated to another agency or directly to them
		  with Preciso and nothing in this Agreement will prevent Preciso and a client
		  from entering into a direct relationship; (vii) Preciso reserves the right
		  to reasonably object to any client at Preciso’s sole discretion.</p>
		<h2><a name="_Toc529199553"></a>
			<strong>3.5 Preciso Representations.</strong>
		</h2>
		<p>Preciso provides the Services “as is” and “as available” 
		  and hereby disclaims
		  all warranties with respect to the Services, whether express or implied,
		  including warranties of merchantability, and fitness for any particular
		  purpose. Preciso does not warrant that the 
		  Services will operate uninterrupted
		  or error-free and it is possible that the Services may be inaccessible,
		  unavailable, or inoperable from time to time. Preciso makes 
		  no representation
		  or warranty about the result Advertiser will obtain through 
		  using the Services
		  including the level of Ad unit impressions or clicks on any Ad unit or
		  the timing of delivery of such impressions and/or clicks
		  under this Agreement.
		  Preciso is not responsible for the receipt of queries from end users to
		  whom the Ads where displayed or the transmission of data between the Ads
		  and Preciso.</p>
		<h2>
			<a name="_Toc529199554"></a>
			<strong>3.6 Contents Representations.</strong>
		</h2>
		<p>Preciso’s Actions. Advertiser can request to work with
		  Preciso (including within
		  the technologies where such functionality is available) to manage display
		  preferences when and to the extent such controls are made available to
		  Preciso. Advertiser acknowledges that Preciso has limited control where and
		  how often Ads will be displayed within the network of Publishers. Preciso
		  is committed to provide quality inventory, however, at times Ads may be
		  displayed next to ads of Advertiser’s competitors,
		   or on websites or applications
		  that are undesirable to Advertiser unless Advertiser excludes the website
		  in accordance with Insertion Order. If a Advertiser raises written concern
		  about a website that Ads are being served on, Preciso will to the best of
		  efforts remove the Advertiser's Ads from serving on this inventory. Preciso
		  will use commercially reasonable efforts not to display Ads on websites
		  or applications that it determines to be pornographic, defamatory, obscene,
		  or illegal in nature. If Advertiser notifies Preciso in writing that Ads
		  are being displayed in this manner, Preciso will use commercially reasonable
		  efforts to prevent Ads from continuing to display on 
		  such inventory sources.
		  Preciso retains the authority to remove any Advertiser Content that it deems
		  to be in violation of this Agreement or Rules, in its sole discretion.
		  Preciso reserves the right to pause or terminate campaigns at any time that
		  are no longer eligible to run in accordance with such policies or Rules.
	   </p>
		<h2>
			<a name="_Toc529199555"></a>
			<strong>3.7 Campaign Optimizations.</strong>
		</h2>
		<p>Preciso may optimize towards Advertiser's performance 
		  or goals by programmatically
		  using Ads to create new content (such as Ads and, if Advertiser agrees
		  to receive such Services, emails, or other necessary marketing materials)
		  and inserting them into Advertiser's active campaigns, or create, change,
		  or pause campaigns on the Advertiser's behalf, subject to Advertiser's
		  budget. Preciso will subsequently notify Advertiser if Preciso makes material
		  changes to Ads. The Parties acknowledge and agree that within Preciso’s
		  license, this article shall be read combined with article 3.8 below.</p>
		<h2><a name="_Toc529199556"></a><strong>3.8 Preciso.</strong></h2>
		<p>Advertiser acknowledges and agrees 
		  that if the Advertiser 
		  choose the Preciso’s
		  license, the Advertiser will be the sole responsible for the planning and
		  managing of the advertising campaigns. Preciso’s activities will be limited
		  to standard market assistance activities, such as providing access to the
		  dashboard, explaining its functioning and characteristics. 
		  It remains understood
		  between the Parties that Preciso will not have any role in managing Preciso
		  from a business perspective, any decision and 
		  responsibility on the campaigns
		  will be on the Advertiser.</p>
		<p> </p>
		<h1><a name="_Toc529199557"></a>4. Data.</h1>
		<h2><a name="_Toc529199558"></a>
			<strong>4.1 Data Processing Responsibilities and Rights.</strong>
		</h2>
		<ol>
		  <li>Preciso is and will be deemed to be acting as sole data controller under
			this Agreement with respect to the Preciso Cookies, in each case if and
			to the extent deemed to be personal data.</li>
		</ol>
		<h2><a name="_Toc529199559"></a>
			<strong>4.2 Data Representations, Warranties, and Obligations.</strong>
		</h2>
		<ol>
		  <li>Each Party undertakes, in respect of that which 
			lies within its competence,
			to comply with Data Protection Laws, and each
			Party recognizes that compliance
			with the obligations concerning the protection and 
			safeguarding of information
			is a matter of utmost importance to the other.</li>
		  <li>The Agreement involve the use of Preciso’s technologies -
			where Preciso acts
			as Data Controller – the Advertiser acknowledges and expressly agrees
			to the presence of Preciso’s tracking on the 
			Ads according to the provision
			of the present Agreement.</li>
		  <li>The Advertiser acknowledges and expressly agrees
			that the services of Preciso
			could include profiling activities by means of 
			cookies and/or, in general,
			identifiers with profiling purposes and/or behavioral and/or retargeting
			purposes.</li>
		</ol>
		<p> </p>
		<h1><a name="_Toc529199560"></a>5. Fees.</h1>
		<h2><a name="_Toc529199561"></a><strong>5.1 Fee Determination.</strong></h2>
		<p>Advertiser shall pay Preciso the Fee indicated by Preciso for the Services,
		  accordingly to the prices agreed with each Insertion Order.</p>
		<h2><a name="_Toc529199562"></a>
			<strong>5.2 General Payment Terms.</strong>
		</h2>
		<p>Advertiser agrees that Advertiser has all necessary rights,
		  power, and authority
		  to authorize each such payment. For certain payment methods, the issuer
		  of Advertiser's payment method may charge Advertiser a foreign transaction
		  fee or other charges. Advertiser should check with the 
		  payment method service
		  provider for details. If Advertiser develops credit conditions
		  (e.g., excessive
		  credit card denials, chargebacks, return-to-maker payments
		  due to insufficient
		  funds, or increased risk of insolvency) or Preciso otherwise designates
		  Advertiser as a credit risk, Preciso reserves the right to 
		  require prepayment.
		  Advertiser agrees to maintain sufficient funds or credit availability in
		  Advertiser's payment method to satisfy Advertiser's amounts due and that
		  Preciso will have no obligation to provide the Services if sufficient funds
		  are not available at the time Advertiser's payment is submitted, and Preciso
		  reserves the right to suspend Advertiser's campaigns due to failed payments
		  or insufficient balance. Except as may be set forth in this Agreement,
		  each Party shall be responsible for its own costs and expenses required
		  to conduct and perform its respective services and perform its other
		  obligations hereunder.</p>
		<h2><a name="_Toc529199563"></a><strong>5.3 Promotions.</strong></h2>
		<p>In its sole discretion, Preciso may offer promotions to Advertiser, subject
		  to any terms set out in the applicable written documentation or,
		  if applicable,
		  Insertion Order. If Advertiser accepts the promotion, Advertiser 
		  understands
		  and agrees that after the promotion, the campaign will
		  automatically continue
		  as a paid campaign, unless Advertiser pauses or completes the campaign
		  as described in the applicable Insertion Order. Advertiser is responsible
		  for all campaign costs that occur beyond the parameters of the promotion
		  described in the applicable Insertion Order.</p>
		<h2><a name="_Toc529199564"></a>
			<strong>5.4 Campaign Measurement and Tracking.</strong>
		</h2>
		<p>Claims. Unless expressly agreed to in writing by Preciso, the Fees will be
		  based on Preciso's measurements and tracking through its own servers using
		  the number of impressions, clicks, and 
		  other indicators necessary for calculating
		  the Fees payable by Advertiser. Claims relating to invoices or account
		  charges must be raised by Advertiser within 30 days of receipt or will
		  be barred.</p>
		<h2><a name="_Toc529199565"></a><strong>5.5 Taxes.</strong></h2>
		<p>All payments to Preciso will be made in Euro, unless otherwise agreed to in
		  an Insertion Order. Payments are quoted exclusive of any taxes. Advertiser
		  is responsible for all sales taxes, use taxes, value added taxes, 
		  withholding
		  taxes, and any other similar taxes imposed by federal,
		  state local or foreign
		  governmental entities on the transactions contemplated by this Agreement,
		  excluding taxes based solely upon Preciso’s net income.</p>
		<p> </p>
		<h1><a name="_Toc529199566"></a>6. Term; Termination.</h1>
		<h2><a name="_Toc529199567"></a><strong>6.1 Term.</strong></h2>
		<p>This Agreement shall commence upon the Effective Date and continue unless
		  and until terminated in accordance with the provisions hereof or until
		  otherwise provided in the Insertion Order (such period, the “
		  <strong>Term</strong>”).</p>
		<h2>
			<a name="_Toc529199568"></a>
			<strong>6.2 Termination for Convenience.</strong>
		</h2>
		<p>Either Party may terminate this Agreement, 
		  for any reason or no reason, effective
		  as of the last day of a calendar quarter, by providing at least thirty
		  (30) days’ notice to the other Party.</p>
		<h2><a name="_Toc529199569"></a>
			<strong>6.3 Termination for Cause.</strong>
		</h2>
		<p>Preciso may terminate this Agreement immediately upon 
			written notice to Advertiser
		  in the event that Advertiser materially breaches this Agreement; 
		  <u>provided</u>,
		  <u>however</u>, that if such breach is capable of cure, Advertiser will
		  have thirty (30) days (or such additional cure period, if any, as Preciso
		  may so authorize in writing) from the date of such notice to cure such
		  breach (during which time such Advertiser’s use of the Service may be (but
		  is not obligated to be) suspended).</p>
		<h2>
			<a name="_Toc529199570"></a>
			<strong>6.4 Termination due to Unilateral Amendment.</strong>
		</h2>
		<p>Advertiser may terminate this Agreement within thirty (30)
		  days after receiving
		  notice of a Unilateral Amendment in the event that Advertiser reasonably
		  believes that, after using Reasonable Endeavours (as defined below), it
		  will not be able to comply with the terms and conditions of this Agreement
		  as amended by such Unilateral Amendment.</p>
		<h2><a name="_Toc529199571"></a>
			<strong>6.5 Termination due to Change in Rule.</strong>
		</h2>
		<p>Preciso may terminate this Agreement due to a change in, or addition of a,
		  Rule by providing at least 30 days’ prior notice (or such shorter period
		  as provided in the applicable notice, if Preciso reasonably determines that
		  such change in Rule or additional Rule will apply prior to the application
		  of such 30-day period) in the event that Preciso reasonably believes that,
		  after using Reasonable Endeavours, 
		  the Services and/or the operation thereof
		  will not be able to comply with the terms and conditions of the changed
		  or additional Rule.</p>
		<p> </p>
		<h1><a name="_Toc529199572"></a>7. Intellectual Property Rights.</h1>
		<h2><a name="_Toc529199573"></a><strong>7.1 Mutual Obligations.</strong></h2>
		<p>As between the Parties: (i) Preciso owns and will retain all right, title,
		  and interest in and to its intellectual property,
		   including, without limitation,
		  to the Services (in each case, including, without limitation, all software,
		  technologies, concepts, methodologies, techniques, models,
		  templates, algorithms,
		  trade secrets, processes, information, materials, source codes and know-how
		  contained therein or related thereto, all modifications,
		  updates, enhancements
		  and derivative works thereof, all documentation and manuals related thereto
		  and all other aspects of such technology), and all intellectual property
		  and proprietary rights in and to all of the foregoing; and (ii) Advertiser
		  owns and will retain all right, title and
		  interest in and to its intellectual
		  property, including all software and technologies related thereto, and
		  any modifications, updates, enhancements and derivative works thereof,
		  and all intellectual property and proprietary rights in and to all of the
		  foregoing. Each Party reserves any and all rights not expressly granted
		  in this Agreement and disclaims all implied licenses, including, without
		  limitation, implied licenses to software, technology,
		   trademarks, copyrights,
		  trade secrets, patents and other intellectual property. 
		  Advertiser guarantees
		  that no (intellectual and/or industrial property) rights of any third party
		  are infringed by the Ad Inventory or any other data supplied by Advertiser
		  to Preciso in connection with the Service(s). Advertiser indemnifies Preciso
		  against all claims of third parties in this regard and shall compensate
		  Preciso on demand for damages suffered by Preciso as a consequence and in
		  connection with such an infringement.</p>
		<h2><a name="_Toc529199574"></a><strong>7.2 Preciso.</strong></h2>
		<p>Without limiting the generality of the foregoing,
		  Preciso retains all right,
		  title and interest in and to the Service(s), the technology used by Preciso
		  to operate the Service(s), Preciso’s trademarks, and all enhancements made
		  by Preciso to any of the foregoing from time to time, including but not
		  limited to all patent, trademark, copyright, trade secret and all other
		  intellectual property rights in the foregoing. Advertiser may not use the
		  Service(s) except pursuant to the limited rights expressly granted in this
		  Agreement and all rights not expressly granted
		  herein are reserved by Preciso.
		  Advertiser shall not, and shall not attempt to, and will not assist or
		  knowingly permit any third party to: (i)
		  alter, modify, adjust, copy, reproduce,
		  delete, damage, disassemble, decompile, reverse engineer or
		  create derivative
		  works of the Service(s) and/or the Preciso and/or tools of third party
		  suppliers instructed by Preciso, or any portions thereof; or (ii) breach,
		  disable, tamper or interfere with the proper operation of the Service(s)
		  and/or the Preciso and/or tools of third parties, or with any security
		  measures designed to protect the Service(s) and/or the Preciso and/or tools
		  of third party suppliers instructed by Preciso. Advertiser shall compensate
		  Preciso for any damages and costs Preciso may suffer.</p>
		<h2>
			<a name="_Toc529199575"></a>
			<strong>7.3 Publicity.</strong>
		</h2>
		<p>Neither Party may use the other Party’s name, logos or 
		  trademarks for publicity
		  or general marketing communications purposes without prior written consent;
		  provided that: (i) Preciso may use Advertiser’s name, logos, and trademarks,
		  and may disclose Advertiser’s use of the Service, (a) on Preciso website
		  (including, without limitation, in blog posts on such website), (b) on
		  lists of Advertisers, and (c) in the Services informational materials;
		  and (ii) each of Preciso and its Affiliates may disclose Advertiser’s use
		  of the Service and the fact of Advertiser’s execution of this 
		  Agreement.</p>
		<p> </p>
		<h1>
			<a name="_Toc529199576"></a>8. Indemnification
		</h1>
		<h2>
			<a name="_Toc529199577"></a>
			<strong>8.1 Advertiser Indemnification.</strong>
		</h2>
		<p>Advertiser will defend, indemnify, and hold harmless 
		  Preciso and its officers,
		  directors, employees and subsidiaries from and against all liabilities,
		  damages and costs (including settlement costs and reasonable attorneys’
		  fees) arising out of any claim by a third party regarding (i) Advertiser’s
		  breach of this Agreement; and (ii) 
		  any violation, infringement or misappropriation
		  of any law or third-party right (including intellectual property, property,
		  privacy or publicity rights) by Advertiser or Ads.</p>
		<h1><a name="_Toc529199578"></a>9. Limitation of Liability.</h1>
		<h2>
			<a name="_Toc529199579"></a>
			<strong>9.1 Disclaimer of indirect damages.</strong>
		</h2>
		<p>Preciso will not, under any circumstances, be liable to Advertiser for any
		  loss of profits, loss of business 
		  (whether direct or indirect) or any indirect,
		  consequential, incidental, punitive, special, or exemplary damages related
		  to this agreement, even if Preciso is apprised of the likelihood of such
		  damages occurring.</p>
		<h2><a name="_Toc529199580"></a><strong>9.2 Cap on liability.</strong></h2>
		<p>Under no circumstances will Preciso’s collective total 
		  liability arising out
		  this agreement exceed the total amount paid by Advertiser to Preciso under
		  this agreement in the six months immediately preceding the first event
		  giving rise to the claim (determined as of the date of any final judgment
		  in an action).</p>
		<h2><a name="_Toc529199581"></a><strong>9.3 Exclusions.</strong></h2>
		<p>Nothing in this agreement shall exclude or limit either Party’s liability
		  for:</p>
		<ol>
		  <li>Fraud or fraudulent misrepresentation;</li>
		  <li>Intentional misconduct;</li>
		  <li>Payment of sums properly due and owing to the other in the course
		   of normal performance hereof (if any);</li>
		  <li>Death or personal injury caused by negligence; or</li>
		  <li>Matters that cannot be excluded or limited by applicable rules.</li>
		</ol>
		<h1><a name="_Toc529199582"></a>10. Confidentiality.</h1>
		<h2><a name="_Toc529199583"></a><strong>10.1 General.</strong></h2>
		<p>In connection with this Agreement, each Party may disclose, or may learn
		  of or have access to, certain Confidential Information owned by the other
		  Party. “<strong>Confidential</strong> <strong>Information</strong>” means
		  any information whether oral or written disclosed by a Party to the other
		  Party under this Agreement that is marked or addressed as confidential
		  or should reasonably be considered confidential or proprietary under the
		  circumstances, including, without limitation, know-how and trade secrets,
		  processes, information regarding products, costs, technology, software,
		  personnel, customers, research, development, know-how, 
		  financial information,
		  customer and supplier lists, forecasts, and projections, marketing and
		  business plans and opportunities; and existence of any business discussions
		  or negotiations, even if any such information is aggregated or anonymised.
		  Confidential Information also includes the terms of this Agreement.</p>
		<h2><a name="_Toc529199584"></a>
			<strong>10.2 Exclusions.</strong></h2>
		<p>Notwithstanding the foregoing, Confidential Information is deemed not to
		  include information that: (i) is publicly available at the time disclosed;
		  (ii) is or becomes publicly available through no fault of the receiving
		  Party;(iii) is rightfully communicated to the receiving Party by 
		  a person(s)or entity(ies) not bound by confidentiality 
		  obligations with respect 
		  thereto;(iv) is already in the receiving Party’s possession 
		  free of any confidentiality obligations with respect thereto;
		  (v) is independently developed by a Party without use of any 
		  Confidential Information of the other Party; or (vi)
		  is approved for release or disclosure by the disclosing Party without 
		  restriction.</p>
		<h2><a name="_Toc529199585"></a><strong>10.3 Obligations.</strong></h2>
		<p>Except as expressly permitted in this Agreement, each Party shall maintain
		  the Confidential Information of the other Party in strict confidence and
		  shall not disclose, publish or copy any part of such 
		  Confidential Information
		  except as required to perform authorised obligations under this Agreement.
		  Each Party shall take all necessary 
		  precautions in handling the Confidential
		  Information of the other Party and agrees not to disclose any Confidential
		  Information of the disclosing Party to third parties or to such Party’s
		  employees or contractors, and to limit disclosures on a strict need-to-know
		  basis; provided that each Party shall be liable for the acts or omissions
		  of any party that obtains Confidential Information through such Party.
		  However: (i) a Party may disclose Confidential Information of the other
		  Party pursuant to the order or requirement of a court, 
		  administrative agency,or other governmental body; provided that,
		  if permitted, such Party gives reasonable notice to the disclosing
		  Party and uses Reasonable Endeavours to provide the 
		  disclosing Party with the opportunity to seek a protective
		  order or the equivalent (at the disclosing Party’s expense)); and (ii)
		  Preciso may, in its reasonable discretion, disclose Confidential Information
		  of Advertiser pursuant to a discovery or similar request by another 
		  Advertiser.Upon the expiration or termination of this Agreement,
		  each Party will promptly return or destroy all Confidential Information of 
		  the other Party in its possession or control.</p>
		<h1><a name="_Toc529199586"></a>11. General</h1>
		<h2><a name="_Toc529199587"></a>
			<strong>11.1 Independent Contractors.</strong>
		</h2>
		<p>Each Party is an independent contractor in relation to the other Party 
		  with respect to all matters arising under this Agreement. 
		  Nothing herein shall be deemed to establish a partnership,joint 
		  venture,association or employment relationship between the Parties.
		  Each Party shall ensure the 
		  timely disposition of all of its respective employee 
		  matters in connection with its organisation,including, 
		  without limitation, employee benefits,
		  insurance, withholdings,taxes, and 
		  similar employee-related matters.</p>
		<h2><a name="_Toc529199588"></a><strong>11.2 Severability.</strong></h2>
		<p>
		  If any provision of this Agreement is held to be void,invalid or 
		  inoperative,the remaining provisions of this Agreement shall 
		  continue in effect and the invalid portion of any provision 
		  shall be deemed modified to the least degree necessary to 
		  remedy such invalidity while retaining the original
		  intent of the Parties.</p>
		<h2><a name="_Toc529199589"></a><strong>11.3 Waivers.</strong></h2>
		<p>The failure of either Party to partially or fully exercise any rights or
		  the waiver of either Party of any breach shall not prevent a subsequent
		  exercise of such right or be deemed a waiver of any subsequent breach of
		  the same or any other term of this Agreement.</p>
		<h2><a name="_Toc529199590"></a><strong>11.4 Remedies.</strong></h2>
		<p>The remedies under this Agreement shall be cumulative and not alternative
		  and the election of one remedy for a breach shall not preclude pursuit of 
		  other remedies unless expressly provided otherwise in this Agreement.</p>
		<h2><a name="_Toc529199591"></a><strong>11.5 Assignment.</strong></h2>
		<p>Neither Party may assign this Agreement, whether by operation of law or 
		  otherwise,to any other person or entity without the prior written consent 
		  of the other Party; provided that,without the prior written consent of the 
		  other Party:Preciso may assign this Agreement to an Affiliate or otherwise
		  pursuant to a change of control.</p>
		<h2><a name="_Toc529199592"></a><strong>11.6 Survival.</strong></h2>
		<p>Notwithstanding termination hereof, any provisions of this Agreement that
		  by their nature are intended to survive will survive termination.</p>
		<h2><a name="_Toc529199593"></a><strong>11.7 Notice.</strong></h2>
		<p>All notices under this Agreement must be in writing(including,without 
		  limitation,email) and sent to the attention of the other Party’s 
		  “contact for notices” and, if any, “additional contact” set forth
		  on the signature page hereof.Either Party may change its contact
		  for notices and/or additional contact by providing five (5) business 
		  days’ prior notice to the other Party.Notice
		  will be deemed given when delivered.</p>
		<h2><a name="_Toc529199594"></a>
			<strong>11.8 Choice of Law; Jurisdiction.</strong>
		</h2>
		<p>All questions concerning the validity, interpretation and performance of
		  this Agreement shall be governed by and decided in accordance with the
		  laws of Italy,without regard to any conflicts of laws or principles thereof
		  Any dispute arising under this Agreement shall be determined by the Pescara
		  court, which shall have exclusive jurisdiction, and each of the Parties
		  hereby consents to such exclusive jurisdiction.</p>
		<h2><a name="_Toc529199595"></a><strong>11.9 Authority.</strong></h2>
		<p>The person executing this Agreement for and on behalf of each Party 
		  represents and warrants to each other that he/she has been, 
		  and is on the Effective Date, duly authorised by all necessary 
		  and appropriate action to execute this Agreement.</p>
		<h2><a name="_Toc529199596"></a><strong>11.10 Entire Agreement.</strong></h2>
		<p>This Agreement sets forth the entire agreement between the Parties on this
		  subject matter contained herein and supersedes all prior negotiations,
		  understandings and agreements between the Parties concerning this subject
		  matter.Except as expressly set forth herein (including,without limitation,
		  with regard to Unilateral Amendments, as set forth in Section 2.3 hereof),
		  no amendment or modification of this Agreement shall be made except by
		  a writing signed by both Parties.</p>
		<h2><a name="_Toc529199596"></a><strong>11.11 License.</strong></h2>
		<p>Preciso Bid-Smart Advertising is free software, and is released under the
		  terms of the <abbr>GPL</abbr> (GNU General Public License) version 3 or
		  (at your option) any later version. See 
		  <a href="../license.txt">license.txt</a>.
		  Preciso3c is a proprietary product of Preciso Srl and access to code is
		  restricted </p>
		<form id='terms' action="https://api.preciso.net/api/plugin/terms" method="post">
		  <input type="hidden" name="agreed" value="true" id='agreed'>
		  <input type="hidden" name="token" value="token" id='token'>
		  <input type="hidden" id='shop' value="<?php echo wp_kses_post( $shop_url ); ?>">
		  <input type="button" class="btn btn-green"  value="I agree" id='regisnSubmit' style="border-radius:0!important">
		   <?php echo '<input type="hidden" name="bk-ajax-nonce" id="bk-ajax-nonce" value="' . wp_kses_post( wp_create_nonce( 'bk-ajax-nonce' ) ) . '" />'; ?>
		</form>
	  </div>
	</div>
	<div class="clear"></div>
  </div>
<?php
$dir = plugin_dir_path( __DIR__ );
$currentDate = gmdate( 'Y-m-d' );
$updated_at = get_option( 'update_xml_and_json_at' );

if ( '' == $updated_at ) {
	include_once $dir . 'store-xml-gen.php';
	update_option( 'update_xml_and_json_at', $currentDate );
}

$diff = abs( strtotime( $currentDate ) - strtotime( $updated_at ) );
$years = floor( $diff / ( 365 * 60 * 60 * 24 ) );
$months = floor( ( $diff - $years * 365 * 60 * 60 * 24 ) / ( 30 * 60 * 60 * 24 ) );
$days = floor( ( $diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24 ) / ( 60 * 60 * 24 ) );

if ( $days > 0 ) {
	include_once $dir . 'store-xml-gen.php';
	update_option( 'update_xml_and_json_at', $currentDate );
}

?>
