<?php
/**
 * Uninstall file for PrecisionQA
 *
 * This file is executed when the plugin is uninstalled.
 *
 * @package PrecisionQA
 * @since 0.0.1
 */

// If uninstall not called from WordPress, exit
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Check if user has permission to uninstall
if ( function_exists( 'current_user_can' ) && ! current_user_can( 'activate_plugins' ) ) {
	return;
}

// Clean up plugin options
if ( function_exists( 'delete_option' ) ) {
	delete_option( 'precisionqa_active' );
	delete_option( 'precisionqa_registered_types' );
	delete_option( 'precisionqa_admin_notices' );
	delete_option( 'precisionqa_default_image_id' );

	// Clean up any other options that might have been created
	$options_to_delete = array(
		'precisionqa_version',
		'precisionqa_settings',
		'precisionqa_forms_created',
		'precisionqa_posts_created',
	);

	foreach ( $options_to_delete as $option ) {
		delete_option( $option );
	}
}

// Clean up any transients
if ( function_exists( 'delete_transient' ) ) {
	delete_transient( 'precisionqa_cache' );
	delete_transient( 'precisionqa_forms_cache' );
	delete_transient( 'precisionqa_posts_cache' );
}

// Remove any scheduled cron events
if ( function_exists( 'wp_clear_scheduled_hook' ) ) {
	wp_clear_scheduled_hook( 'precisionqa_cleanup' );
}

// Custom tables: none are created by this plugin. Intentionally no action here.

// Clean up any user meta that might have been created
if ( function_exists( 'get_users' ) && function_exists( 'delete_user_meta' ) ) {
	$users = get_users( array( 'fields' => 'ID' ) );
	foreach ( $users as $user_id ) {
		delete_user_meta( $user_id, 'precisionqa_preferences' );
		delete_user_meta( $user_id, 'precisionqa_last_used' );
	}
}

// Clean up any post meta that might have been created
if ( function_exists( 'delete_post_meta_by_key' ) ) {
	delete_post_meta_by_key( 'precisionqa_form_embedded' );
	delete_post_meta_by_key( 'precisionqa_embed_date' );
}

// Clean up any term meta that might have been created
if ( function_exists( 'delete_term_meta_by_key' ) ) {
	delete_term_meta_by_key( 'precisionqa_usage_count' );
}

// Flush rewrite rules to clean up any custom post types
if ( function_exists( 'flush_rewrite_rules' ) ) {
	flush_rewrite_rules();
}

// No debug logging here to avoid production development function warnings.
