<?php
/**
 * Plugin Name: PrecisionQA
 * Plugin URI: https://kishan-gondaliya-7270.vercel.app
 * Description: A comprehensive testing utility for WordPress developers and QA testers. Create forms, manage custom post types, embed content, and automate testing workflows.
 * Version: 0.0.1
 * Requires at least: 6.0
 * Tested up to: 6.8
 * Requires PHP: 7.4
 * Author: Kishan
 * Author URI: https://profiles.wordpress.org/kishu7270
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: precisionqa
 * Domain Path: /languages
 
 *
 * @package PrecisionQA
 * @version 0.0.1
 * @author Kishan
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants
define( 'PRECISIONQA_VERSION', '0.0.1' );
define( 'PRECISIONQA_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'PRECISIONQA_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'PRECISIONQA_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * Main plugin class
 *
 * @since 0.0.1
 */
final class PrecisionQA {

	/**
	 * Plugin instance
	 *
	 * @var PrecisionQA
	 */
	private static $instance = null;

	/**
	 * Admin class instance
	 *
	 * @var PrecisionQA_Admin
	 */
	public $admin;

	/**
	 * Gravity Forms handler instance
	 *
	 * @var PrecisionQA_Gravity_Forms
	 */
	public $gravity_forms;

	/**
	 * Custom Post Types handler instance
	 *
	 * @var PrecisionQA_Custom_Post_Types
	 */
	public $custom_post_types;

	/**
	 * Form Embedding handler instance
	 *
	 * @var PrecisionQA_Form_Embedding
	 */
	public $form_embedding;

	/**
	 * Security handler instance
	 *
	 * @var PrecisionQA_Security
	 */
	public $security;

	/**
	 * Get plugin instance
	 *
	 * @return PrecisionQA
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor
	 */
	private function __construct() {
		$this->init_hooks();
		$this->load_dependencies();
	}

	/**
	 * Initialize WordPress hooks
	 */
	private function init_hooks() {
		// Translations are auto-loaded on WordPress.org for the plugin slug.
		register_activation_hook( __FILE__, array( $this, 'activate' ) );
		register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
	}

	/**
	 * Load plugin dependencies
	 */
	private function load_dependencies() {
		// Load required files
		require_once PRECISIONQA_PLUGIN_DIR . 'includes/class-security.php';
		require_once PRECISIONQA_PLUGIN_DIR . 'includes/class-admin.php';
		require_once PRECISIONQA_PLUGIN_DIR . 'includes/class-gravity-forms.php';
		require_once PRECISIONQA_PLUGIN_DIR . 'includes/class-custom-post-types.php';
		require_once PRECISIONQA_PLUGIN_DIR . 'includes/class-form-embedding.php';

		// Initialize classes
		$this->security = new PrecisionQA_Security( $this );
		$this->admin = new PrecisionQA_Admin( $this );
		$this->gravity_forms = new PrecisionQA_Gravity_Forms( $this );
		$this->custom_post_types = new PrecisionQA_Custom_Post_Types( $this );
		$this->form_embedding = new PrecisionQA_Form_Embedding( $this );
	}



	// No explicit load_plugin_textdomain() needed when hosted on WordPress.org.

	/**
	 * Plugin activation
	 */
	public function activate() {
		// Add default options
		add_option( 'precisionqa_active', true );
		add_option( 'precisionqa_registered_types', array() );
		add_option( 'precisionqa_forms_created', array() );
		add_option( 'precisionqa_posts_created', array() );

		// Flush rewrite rules for custom post types
		flush_rewrite_rules();
	}

	/**
	 * Plugin deactivation
	 */
	public function deactivate() {
		// Flush rewrite rules
		flush_rewrite_rules();
	}

	/**
	 * Check if Gravity Forms is active
	 *
	 * @return bool
	 */
	public function is_gravity_forms_active() {
		return class_exists( 'GFAPI' );
	}

	/**
	 * Get plugin settings
	 *
	 * @param string $key Setting key.
	 * @param mixed  $default Default value.
	 * @return mixed
	 */
	public function get_setting( $key, $default = null ) {
		return get_option( 'precisionqa_' . $key, $default );
	}

	/**
	 * Update plugin setting
	 *
	 * @param string $key Setting key.
	 * @param mixed  $value Setting value.
	 * @return bool
	 */
	public function update_setting( $key, $value ) {
		return update_option( 'precisionqa_' . $key, $value );
	}
}

/**
 * Initialize the plugin
 */
function precisionqa() {
	return PrecisionQA::get_instance();
}

// Start the plugin
precisionqa();
