<?php
/**
 * Admin Page View Template
 *
 * @package PrecisionQA
 * @since 0.0.1
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get post types for the form
$post_types = get_post_types( array( 'public' => true ), 'names' );
?>

<div class="wrap" id="precisionqa-admin">
	<h1 class="wp-heading-inline">
		<?php esc_html_e( 'PrecisionQA - WordPress Testing Utility', 'precisionqa' ); ?>
	</h1>


	<!-- Form Automation Section -->
	<div class="gf-cpt-section gravity-forms-section">
		<h2><span class="dashicons dashicons-feedback" aria-hidden="true"></span><?php esc_html_e( 'Form Automation', 'precisionqa' ); ?></h2>
		
		<?php if ( $this->plugin->is_gravity_forms_active() ) : ?>
			<form method="post" action="" class="gf-cpt-form">
				<?php wp_nonce_field( 'precisionqa_action', 'precisionqa_nonce' ); ?>
				
				<div class="form-buttons-group">
					<input type="submit" name="generate_standard_form" value="<?php esc_attr_e( 'Create Standard Fields Form', 'precisionqa' ); ?>" class="button button-primary">
					<input type="submit" name="generate_advanced_form" value="<?php esc_attr_e( 'Create Advanced Fields Form', 'precisionqa' ); ?>" class="button button-primary">
					<input type="submit" name="generate_post_fields_form" value="<?php esc_attr_e( 'Create Post Fields Form', 'precisionqa' ); ?>" class="button button-primary">
					<input type="submit" name="generate_pricing_form" value="<?php esc_attr_e( 'Create Pricing Fields Form', 'precisionqa' ); ?>" class="button button-primary">
					<input type="submit" name="generate_multipage_form" value="<?php esc_attr_e( 'Create Multipage Form', 'precisionqa' ); ?>" class="button button-primary">
					<input type="submit" name="generate_conditional_form" value="<?php esc_attr_e( 'Create Conditional Form', 'precisionqa' ); ?>" class="button button-primary">
				</div>

				<div class="form-buttons-group">
					<input type="submit" name="generate_conditional_dropdown_form" value="<?php esc_attr_e( 'Create Conditional Form for Dropdown', 'precisionqa' ); ?>" class="button button-primary">
					<input type="submit" name="generate_conditional_textfield_form" value="<?php esc_attr_e( 'Create Conditional Form for Text Field', 'precisionqa' ); ?>" class="button button-primary">
					<input type="submit" name="generate_conditional_paragraph_form" value="<?php esc_attr_e( 'Create Conditional Form for Paragraph', 'precisionqa' ); ?>" class="button button-primary">
					<input type="submit" name="generate_conditional_checkbox_form" value="<?php esc_attr_e( 'Create Conditional Form for Checkbox', 'precisionqa' ); ?>" class="button button-primary">
					<input type="submit" name="generate_conditional_radio_form" value="<?php esc_attr_e( 'Create Conditional Form for Radio Button', 'precisionqa' ); ?>" class="button button-primary">
					<input type="submit" name="generate_conditional_multiplechoice_form" value="<?php esc_attr_e( 'Create Conditional Form for Multiple Choice', 'precisionqa' ); ?>" class="button button-primary">
				</div>
			</form>
		<?php else : ?>
			<div class="notice notice-warning">
				<p><strong><?php esc_html_e( 'Gravity Forms Required', 'precisionqa' ); ?></strong></p>
				<p><?php esc_html_e( 'Form automation features require Gravity Forms to be installed and activated. You can still use Custom Post Type and Content Embedding features.', 'precisionqa' ); ?></p>
				<p><a href="https://www.gravityforms.com/" target="_blank" class="button button-secondary"><?php esc_html_e( 'Get Gravity Forms', 'precisionqa' ); ?></a></p>
			</div>
		<?php endif; ?>
	</div>


	<!-- Custom Post Type Section -->
	<div class="gf-cpt-section custom-post-types-section">
		<h2><span class="dashicons dashicons-admin-post" aria-hidden="true"></span><?php esc_html_e( 'Custom Post Type Operations', 'precisionqa' ); ?></h2>
		
		<!-- Form 1: Generate Test Post -->
		<form method="post" action="" class="gf-cpt-form">
			<?php wp_nonce_field( 'precisionqa_action', 'precisionqa_nonce' ); ?>
			
			<div class="form-row">
				<label for="post_type"><?php esc_html_e( 'Select Custom Post Type:', 'precisionqa' ); ?></label>
				<select name="post_type" id="post_type" required>
					<?php foreach ( $post_types as $post_type ) : ?>
						<option value="<?php echo esc_attr( $post_type ); ?>"><?php echo esc_html( $post_type ); ?></option>
					<?php endforeach; ?>
				</select>
				<input type="submit" name="generate_posts" value="<?php esc_attr_e( 'Generate Test Post', 'precisionqa' ); ?>" class="button button-secondary">
			</div>
		</form>

		<!-- Form 2: Create New Custom Post Type -->
		<form method="post" action="" class="gf-cpt-form">
			<?php wp_nonce_field( 'precisionqa_action', 'precisionqa_nonce' ); ?>
			
			<div class="form-row">
				<h3><?php esc_html_e( 'Create New Custom Post Type', 'precisionqa' ); ?></h3>
				<label for="new_cpt"><?php esc_html_e( 'Custom Post Type Name:', 'precisionqa' ); ?></label>
				<input type="text" name="new_cpt" id="new_cpt" placeholder="<?php esc_attr_e( 'Enter custom post type name', 'precisionqa' ); ?>" required>
				<input type="submit" name="create_cpt" value="<?php esc_attr_e( 'Create Custom Post Type', 'precisionqa' ); ?>" class="button button-primary">
			</div>
		</form>
	</div>


	<!-- Content Embedding Section -->
	<div class="gf-cpt-section form-embedding-section">
		<h2><span class="dashicons dashicons-admin-page" aria-hidden="true"></span><?php esc_html_e( 'Embed Content into Post', 'precisionqa' ); ?></h2>
		
		<form method="post" action="" class="gf-cpt-form">
			<?php wp_nonce_field( 'precisionqa_action', 'precisionqa_nonce' ); ?>
			
			<?php if ( $this->plugin->is_gravity_forms_active() ) : ?>
				<?php
				$forms = GFAPI::get_forms();
				$posts = get_posts( array( 'numberposts' => -1, 'post_type' => 'any' ) );
				?>
				
				<div class="form-row">
					<label for="selected_form"><?php esc_html_e( 'Select Form:', 'precisionqa' ); ?></label>
					<select name="selected_form" id="selected_form" required>
						<option value=""><?php esc_html_e( '-- Select a form --', 'precisionqa' ); ?></option>
						<?php foreach ( $forms as $form ) : ?>
							<option value="<?php echo esc_attr( $form['id'] ); ?>"><?php echo esc_html( $form['title'] ); ?></option>
						<?php endforeach; ?>
					</select>
				</div>

				<div class="form-row">
					<label for="selected_post"><?php esc_html_e( 'Select Post:', 'precisionqa' ); ?></label>
					<select name="selected_post" id="selected_post">
						<option value=""><?php esc_html_e( '-- Select a post --', 'precisionqa' ); ?></option>
						<?php foreach ( $posts as $post ) : ?>
							<option value="<?php echo esc_attr( $post->ID ); ?>"><?php echo esc_html( $post->post_title ); ?></option>
						<?php endforeach; ?>
					</select>
				</div>

				<div class="form-row">
					<label for="new_post_title"><?php esc_html_e( 'Or enter new post title:', 'precisionqa' ); ?></label>
					<input type="text" name="new_post_title" id="new_post_title" placeholder="<?php esc_attr_e( 'Enter new post title', 'precisionqa' ); ?>">
				</div>

				<div class="form-row">
					<input type="submit" name="embed_form" value="<?php esc_attr_e( 'Embed Content', 'precisionqa' ); ?>" class="button button-primary">
				</div>
			<?php else : ?>
				<div class="notice notice-warning">
					<p><strong><?php esc_html_e( 'Gravity Forms Required', 'precisionqa' ); ?></strong></p>
					<p><?php esc_html_e( 'Content embedding features require Gravity Forms to be installed and activated. You can still use Custom Post Type features.', 'precisionqa' ); ?></p>
					<p><a href="https://www.gravityforms.com/" target="_blank" class="button button-secondary"><?php esc_html_e( 'Get Gravity Forms', 'precisionqa' ); ?></a></p>
				</div>
			<?php endif; ?>
		</form>
	</div>


	<!-- Performance Test Utility Section -->
	<div class="gf-cpt-section performance-test-section">
		<h2><span class="dashicons dashicons-performance" aria-hidden="true"></span><?php esc_html_e( 'Performance Test Utility', 'precisionqa' ); ?></h2>
		<p><?php esc_html_e( 'Bulk create posts or pages with a selected Gravity Form embedded.', 'precisionqa' ); ?></p>
		
		<form method="post" action="" class="gf-cpt-form">
			<?php wp_nonce_field( 'precisionqa_action', 'precisionqa_nonce' ); ?>
			
			<?php if ( $this->plugin->is_gravity_forms_active() ) : ?>
				<?php
				$forms = GFAPI::get_forms();
				if ( ! empty( $forms ) ) :
				?>
					<div class="form-row">
						<label for="perform_form_id"><?php esc_html_e( '1. Select Gravity Form:', 'precisionqa' ); ?></label>
						<select name="perform_form_id" id="perform_form_id" required>
							<?php foreach ( $forms as $form ) : ?>
								<option value="<?php echo esc_attr( $form['id'] ); ?>"><?php echo esc_html( $form['title'] ); ?></option>
							<?php endforeach; ?>
						</select>
					</div>

					<div class="form-row">
						<label for="perform_num_posts"><?php esc_html_e( '2. Number of Posts/Pages to Create:', 'precisionqa' ); ?></label>
						<input type="number" name="perform_num_posts" id="perform_num_posts" required min="1" value="10">
					</div>

					<div class="form-row">
						<label for="perform_post_type"><?php esc_html_e( '3. Create as:', 'precisionqa' ); ?></label>
						<select name="perform_post_type" id="perform_post_type" required>
							<option value="post"><?php esc_html_e( 'Post', 'precisionqa' ); ?></option>
							<option value="page"><?php esc_html_e( 'Page', 'precisionqa' ); ?></option>
						</select>
					</div>

					<div class="form-row">
						<input type="submit" name="submit_perform_bulk_create" value="<?php esc_attr_e( 'Create Posts/Pages with Form', 'precisionqa' ); ?>" class="button button-primary">
					</div>
				<?php else : ?>
					<div class="notice notice-warning">
						<p><?php esc_html_e( 'No Gravity Forms found. Please create a form first to use this utility.', 'precisionqa' ); ?></p>
					</div>
				<?php endif; ?>
			<?php else : ?>
				<div class="notice notice-warning">
					<p><strong><?php esc_html_e( 'Gravity Forms Required', 'precisionqa' ); ?></strong></p>
					<p><?php esc_html_e( 'Performance test utility requires Gravity Forms to be installed and activated.', 'precisionqa' ); ?></p>
					<p><a href="https://www.gravityforms.com/" target="_blank" class="button button-secondary"><?php esc_html_e( 'Get Gravity Forms', 'precisionqa' ); ?></a></p>
				</div>
			<?php endif; ?>
		</form>
	</div>

	<!-- Footer Links (centered icon-only) -->
	<div class="precisionqa-footer" role="contentinfo" aria-label="PrecisionQA links">
		<p class="footer-made">Engineered with precision</p>
		<p class="footer-explore">Explore precision with: <a href="https://precisionqa-ai.onrender.com/landing" target="_blank" rel="noopener noreferrer">AI-powered Test Case Generator</a></p>
		<div class="footer-icons" aria-label="Links">
			<a class="icon linkedin" href="https://www.linkedin.com/in/kishan-gondaliya/" target="_blank" rel="noopener noreferrer" title="LinkedIn" aria-label="LinkedIn">
				<svg viewBox="0 0 24 24" width="20" height="20" xmlns="http://www.w3.org/2000/svg"><path fill="currentColor" d="M4.98 3.5C4.98 4.88 3.86 6 2.5 6S0 4.88 0 3.5 1.12 1 2.5 1s2.48 1.12 2.48 2.5zM.5 8h4V23h-4V8zm7 0h3.8v2.05h.05c.53-1 1.84-2.05 3.78-2.05 4.04 0 4.79 2.66 4.79 6.12V23h-4v-6.65c0-1.59-.03-3.63-2.21-3.63-2.21 0-2.55 1.73-2.55 3.52V23h-4V8z"/></svg>
			</a>
			<a class="icon wordpress" href="https://profiles.wordpress.org/kishu7270" target="_blank" rel="noopener noreferrer" title="WordPress" aria-label="WordPress">
				<span class="dashicons dashicons-wordpress"></span>
			</a>
			<a class="icon profile" href="https://kishan-gondaliya-7270.vercel.app/" target="_blank" rel="noopener noreferrer" title="Portfolio" aria-label="Portfolio">
				<span class="dashicons dashicons-admin-users"></span>
			</a>
			<a class="icon github" href="https://github.com/kishan-gondaliya-7270" target="_blank" rel="noopener noreferrer" title="GitHub" aria-label="GitHub">
				<svg viewBox="0 0 24 24" width="20" height="20" xmlns="http://www.w3.org/2000/svg"><path fill="currentColor" d="M12 .5a12 12 0 0 0-3.79 23.4c.6.11.82-.26.82-.58v-2.02c-3.34.73-4.04-1.61-4.04-1.61-.55-1.4-1.35-1.77-1.35-1.77-1.1-.75.08-.73.08-.73 1.22.09 1.86 1.26 1.86 1.26 1.08 1.85 2.83 1.31 3.52 1 .11-.79.42-1.31.76-1.61-2.67-.3-5.48-1.34-5.48-5.95 0-1.31.47-2.38 1.24-3.22-.12-.3-.54-1.52.12-3.17 0 0 1.01-.32 3.3 1.23a11.4 11.4 0 0 1 6 0c2.28-1.55 3.29-1.23 3.29-1.23.66 1.65.24 2.87.12 3.17.77.84 1.23 1.9 1.23 3.22 0 4.62-2.81 5.65-5.49 5.95.43.37.81 1.1.81 2.22v3.29c0 .32.22.7.82.58A12 12 0 0 0 12 .5z"/></svg>
			</a>
		</div>
	</div>

</div>
