<?php
/**
 * Uninstall script
 * Fired when the plugin is uninstalled
 */

// Exit if accessed directly or not uninstalling
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('pstb_settings');

// Drop custom database tables
global $wpdb;
$table_name = $wpdb->prefix . 'pstb_generation_history';
$wpdb->query("DROP TABLE IF EXISTS {$table_name}");

// Delete all post meta created by the plugin
$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '_pstb_%'");

// Clear any cached data
wp_cache_flush();
