export interface Settings {
  ai_provider: string;
  api_keys: Record<string, string>;
  default_post_status: 'draft' | 'publish';
  image_provider: 'pexels' | 'unsplash' | 'pixabay';
}

export interface AIProvider {
  name: string;
  class: string;
  free: boolean;
  description: string;
}

export interface PostType {
  name: string;
  label: string;
  supports: {
    title: boolean;
    editor: boolean;
    excerpt: boolean;
    thumbnail: boolean;
  };
  taxonomies: Taxonomy[];
}

export interface Taxonomy {
  name: string;
  label: string;
  hierarchical: boolean;
}

export interface GenerationParams {
  topic: string;
  post_type?: string;
  tone?: string;
  length?: string;
  target_audience?: string;
  seo_keywords?: string;
  language?: string;
  format?: string;
  post_status?: 'draft' | 'publish';
  count?: number;
}

export interface GenerationResult {
  success: boolean;
  post_id?: number;
  edit_url?: string;
  view_url?: string;
  error?: string;
}

export interface HistoryItem {
  id: number;
  user_id: number;
  post_id: number | null;
  ai_provider: string;
  parameters: GenerationParams;
  status: 'pending' | 'success' | 'failed';
  error_message: string | null;
  created_at: string;
}

export interface HistoryResponse {
  items: HistoryItem[];
  total: number;
  page: number;
  per_page: number;
  total_pages: number;
}

declare global {
  interface Window {
    pstbData: {
      apiUrl: string;
      nonce: string;
      adminUrl: string;
      pluginUrl: string;
    };
  }
}
