import React, { useEffect } from 'react';

interface ToastProps {
  message: string;
  type?: 'success' | 'error' | 'info';
  onClose: () => void;
  duration?: number;
}

const Toast: React.FC<ToastProps> = ({
  message,
  type = 'info',
  onClose,
  duration = 3000,
}) => {
  useEffect(() => {
    const timer = setTimeout(onClose, duration);
    return () => clearTimeout(timer);
  }, [duration, onClose]);

  const icons = {
    success: '✓',
    error: '✕',
    info: 'ℹ',
  };

  return (
    <div className={`pstb-toast pstb-toast-${type}`}>
      <span className="pstb-toast-icon">{icons[type]}</span>
      <span className="pstb-toast-message">{message}</span>
      <button className="pstb-toast-close" onClick={onClose}>×</button>
    </div>
  );
};

export default Toast;
