import React from 'react';

interface SelectProps extends React.SelectHTMLAttributes<HTMLSelectElement> {
  label?: string;
  error?: string;
  helpText?: string;
  options: Array<{ value: string; label: string }>;
}

const Select: React.FC<SelectProps> = ({
  label,
  error,
  helpText,
  options,
  className = '',
  ...props
}) => {
  return (
    <div className="pstb-input-wrapper">
      {label && <label className="pstb-label">{label}</label>}
      <select
        className={`pstb-select ${error ? 'pstb-input-error' : ''} ${className}`}
        {...props}
      >
        {options.map((option) => (
          <option key={option.value} value={option.value}>
            {option.label}
          </option>
        ))}
      </select>
      {error && <span className="pstb-error-text">{error}</span>}
      {helpText && !error && <span className="pstb-help-text">{helpText}</span>}
    </div>
  );
};

export default Select;
