import React, { useState } from 'react';

interface ParameterSectionProps {
  title: string;
  children: React.ReactNode;
  defaultOpen?: boolean;
}

const ParameterSection: React.FC<ParameterSectionProps> = ({
  title,
  children,
  defaultOpen = false,
}) => {
  const [isOpen, setIsOpen] = useState(defaultOpen);

  return (
    <div className="pstb-parameter-section">
      <button
        className="pstb-parameter-header"
        onClick={() => setIsOpen(!isOpen)}
        type="button"
      >
        <span className="pstb-parameter-title">{title}</span>
        <span className={`pstb-parameter-icon ${isOpen ? 'open' : ''}`}>
          ▼
        </span>
      </button>
      {isOpen && (
        <div className="pstb-parameter-content">
          {children}
        </div>
      )}
    </div>
  );
};

export default ParameterSection;
