import React from 'react';
import { useRoute } from '../hooks/use-route';

interface NavigationProps {
  currentPage: string;
}

const Navigation: React.FC<NavigationProps> = ({ currentPage }) => {
  const { updateQuery } = useRoute();

  const navItems = [
    { id: 'generate', label: 'Generate', icon: '✨', page: 'postybot' },
    { id: 'history', label: 'History', icon: '📜', page: 'postybot-history' },
    { id: 'settings', label: 'Settings', icon: '⚙️', page: 'postybot-settings' },
  ];

  const handleNavigate = (pageName: string) => {
    updateQuery({ page: pageName });
  };

  return (
    <nav className="pstb-nav">
      {navItems.map((item) => (
        <button
          key={item.id}
          className={`pstb-nav-item ${currentPage === item.id ? 'active' : ''}`}
          onClick={() => handleNavigate(item.page)}
        >
          <span className="pstb-nav-icon">{item.icon}</span>
          <span className="pstb-nav-label">{item.label}</span>
        </button>
      ))}
    </nav>
  );
};

export default Navigation;
