import React from 'react';

interface InputProps extends React.InputHTMLAttributes<HTMLInputElement> {
  label?: string;
  error?: string;
  helpText?: string;
}

const Input: React.FC<InputProps> = ({
  label,
  error,
  helpText,
  className = '',
  ...props
}) => {
  return (
    <div className="pstb-input-wrapper">
      {label && <label className="pstb-label">{label}</label>}
      <input
        className={`pstb-input ${error ? 'pstb-input-error' : ''} ${className}`}
        {...props}
      />
      {error && <span className="pstb-error-text">{error}</span>}
      {helpText && !error && <span className="pstb-help-text">{helpText}</span>}
    </div>
  );
};

export default Input;
