import React from 'react';

interface CardProps {
  title?: string;
  children: React.ReactNode;
  className?: string;
}

const Card: React.FC<CardProps> = ({ title, children, className = '' }) => {
  return (
    <div className={`pstb-card ${className}`}>
      {title && <h3 className="pstb-card-title">{title}</h3>}
      <div className="pstb-card-content">{children}</div>
    </div>
  );
};

export default Card;
