import React from 'react';
import { useRoute } from './hooks/use-route';
import Navigation from './components/Navigation';
import Settings from './pages/Settings';
import Generate from './pages/Generate';
import History from './pages/History';

const App: React.FC = () => {
  const { query } = useRoute();
  
  // Determine current page from query.page parameter
  const pageParam = query.page || 'postybot';
  
  let page = 'generate';
  if (pageParam === 'postybot-settings') {
    page = 'settings';
  } else if (pageParam === 'postybot-history') {
    page = 'history';
  }

  const renderPage = () => {
    switch (page) {
      case 'settings':
        return <Settings />;
      case 'history':
        return <History />;
      case 'generate':
      default:
        return <Generate />;
    }
  };

  return (
    <div className="pstb-app">
      <div className="pstb-header">
        <h1 className="pstb-title">
          <img 
            src={`${(window as any).pstbData?.pluginUrl}assets/logo.jpg`} 
            alt="PostyBot Logo" 
            className="pstb-logo"
          />
          PostyBot
        </h1>
        <p className="pstb-subtitle">The Ultimate Content Manager</p>
      </div>
      
      <Navigation currentPage={page} />
      
      <div className="pstb-content">
        {renderPage()}
      </div>
    </div>
  );
};

export default App;
