<?php
/**
 * OpenAI Provider
 */

if (!defined('ABSPATH')) {
    exit;
}

class PSTB_Provider_OpenAI extends PSTB_AI_Provider {
    
    private $api_url = 'https://api.openai.com/v1/chat/completions';
    
    public function generate($prompt) {
        if (!$this->is_configured()) {
            throw new Exception('OpenAI API key not configured');
        }
        
        $body = array(
            'model' => 'gpt-3.5-turbo',
            'messages' => array(
                array(
                    'role' => 'user',
                    'content' => $prompt
                )
            ),
            'temperature' => 0.7,
            'max_tokens' => 2048,
        );
        
        $response = wp_remote_post($this->api_url, array(
            'headers' => array(
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer ' . $this->api_key,
            ),
            'body' => json_encode($body),
            'timeout' => 60,
        ));
        
        if (is_wp_error($response)) {
            throw new Exception('OpenAI API request failed: ' . esc_html($response->get_error_message()));
        }
        
        $body = json_decode(wp_remote_retrieve_body($response), true);
        
        if (isset($body['error'])) {
            throw new Exception('OpenAI API error: ' . esc_html($body['error']['message']));
        }
        
        if (!isset($body['choices'][0]['message']['content'])) {
            throw new Exception('Invalid response from OpenAI API');
        }
        
        return $body['choices'][0]['message']['content'];
    }
}
