<?php
/**
 * Hugging Face Provider
 */

if (!defined('ABSPATH')) {
    exit;
}

class PSTB_Provider_HuggingFace extends PSTB_AI_Provider {
    
    private $api_url = 'https://api-inference.huggingface.co/models/Qwen/Qwen2.5-72B-Instruct';
    
    public function generate($prompt) {
        if (!$this->is_configured()) {
            throw new Exception('Hugging Face API key not configured');
        }
        
        $body = array(
            'inputs' => $prompt,
            'parameters' => array(
                'max_new_tokens' => 2048,
                'temperature' => 0.7,
            )
        );
        
        $response = wp_remote_post($this->api_url, array(
            'headers' => array(
                'Authorization' => 'Bearer ' . $this->api_key,
                'Content-Type' => 'application/json'
            ),
            'body' => json_encode($body),
            'timeout' => 60,
        ));
        
        if (is_wp_error($response)) {
            throw new Exception('Hugging Face API request failed: ' . esc_html($response->get_error_message()));
        }
        
        $body = json_decode(wp_remote_retrieve_body($response), true);
        
        if (isset($body['error'])) {
            throw new Exception('Hugging Face API error: ' . esc_html($body['error']));
        }
        
        if (!isset($body[0]['generated_text'])) {
            throw new Exception('Invalid response from Hugging Face API');
        }
        
        return $body[0]['generated_text'];
    }
}
