<?php
/**
 * Google AI Studio (Gemini) Provider
 */

if (!defined('ABSPATH')) {
    exit;
}

class PSTB_Provider_Gemini extends PSTB_AI_Provider {
    
    private $api_url = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-3-flash-preview:generateContent';
    
    public function generate($prompt) {
        if (!$this->is_configured()) {
            throw new Exception('Gemini API key not configured');
        }
        
        $url = $this->api_url . '?key=' . $this->api_key;
        
        $body = array(
            'contents' => array(
                array(
                    'parts' => array(
                        array('text' => $prompt)
                    )
                )
            ),
            'generationConfig' => array(
                'temperature' => 0.7,
                'maxOutputTokens' => 2048,
            )
        );
        
        $response = wp_remote_post($url, array(
            'headers' => array('Content-Type' => 'application/json'),
            'body' => json_encode($body),
            'timeout' => 60,
        ));
        
        if (is_wp_error($response)) {
            throw new Exception('Gemini API request failed: ' . esc_html($response->get_error_message()));
        }
        
        $body = json_decode(wp_remote_retrieve_body($response), true);
        
        if (isset($body['error'])) {
            throw new Exception('Gemini API error: ' . esc_html($body['error']['message']));
        }
        
        if (!isset($body['candidates'][0]['content']['parts'][0]['text'])) {
            throw new Exception('Invalid response from Gemini API');
        }
        
        return $body['candidates'][0]['content']['parts'][0]['text'];
    }
}
