<?php
/**
 * AI Provider abstraction layer
 */

if (!defined('ABSPATH')) {
    exit;
}

abstract class PSTB_AI_Provider {
    
    protected $api_key;
    
    public function __construct($api_key) {
        $this->api_key = $api_key;
    }
    
    /**
     * Generate content
     * @param string $prompt The prompt to send to AI
     * @return string Generated content
     */
    abstract public function generate($prompt);
    
    /**
     * Check if provider is configured
     */
    public function is_configured() {
        return !empty($this->api_key);
    }
}

class PSTB_AI_Providers {
    
    /**
     * Get available providers
     */
    public static function get_providers() {
        return array(
            'gemini' => array(
                'name' => 'Google AI Studio (Gemini)',
                'class' => 'PSTB_Provider_Gemini',
                'free' => true,
                'description' => 'Free tier: 15 req/min, 1000 req/day',
            ),
            'huggingface' => array(
                'name' => 'Hugging Face',
                'class' => 'PSTB_Provider_HuggingFace',
                'free' => true,
                'description' => 'Free tier: 300 req/hour',
            ),
            'groq' => array(
                'name' => 'Groq',
                'class' => 'PSTB_Provider_Groq',
                'free' => true,
                'description' => 'Fast inference, free tier available',
            ),
            'cerebras' => array(
                'name' => 'Cerebras',
                'class' => 'PSTB_Provider_Cerebras',
                'free' => true,
                'description' => 'High daily limits, consistent performance',
            ),
            'openrouter' => array(
                'name' => 'OpenRouter',
                'class' => 'PSTB_Provider_OpenRouter',
                'free' => true,
                'description' => 'Access to 50+ models, some free',
            ),
            'openai' => array(
                'name' => 'OpenAI',
                'class' => 'PSTB_Provider_OpenAI',
                'free' => false,
                'description' => 'GPT-4, GPT-3.5 (Paid)',
            ),
        );
    }
    
    /**
     * Get provider instance
     */
    public static function get_provider($provider_name, $api_key) {
        $providers = self::get_providers();
        
        if (!isset($providers[$provider_name])) {
            throw new Exception('Invalid AI provider');
        }
        
        $class = $providers[$provider_name]['class'];
        
        if (!class_exists($class)) {
            throw new Exception('Provider class not found');
        }
        
        return new $class($api_key);
    }
}
