<?php
/**
 * Admin interface for PostyBot
 */

if (!defined('ABSPATH')) {
    exit;
}

class PSTB_Admin {
    
    private static $instance = null;
    
    public static function instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('admin_menu', array($this, 'add_menu_pages'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_scripts'));
    }
    
    /**
     * Add admin menu pages
     */
    public function add_menu_pages() {
        // Only show to administrators
        if (!PSTB_Security::is_admin()) {
            return;
        }
        
        // Main menu page
        add_menu_page(
            __('PostyBot', 'postybot'),
            __('PostyBot', 'postybot'),
            'manage_options',
            'postybot',
            array($this, 'render_admin_page'),
            'dashicons-edit-large',
            30
        );
        
        // Generate submenu (default)
        add_submenu_page(
            'postybot',
            __('Generate Content', 'postybot'),
            __('Generate', 'postybot'),
            'manage_options',
            'postybot',
            array($this, 'render_admin_page')
        );
        
        // History submenu
        add_submenu_page(
            'postybot',
            __('Generation History', 'postybot'),
            __('History', 'postybot'),
            'manage_options',
            'postybot-history',
            array($this, 'render_admin_page')
        );
        
        // Settings submenu
        add_submenu_page(
            'postybot',
            __('Settings', 'postybot'),
            __('Settings', 'postybot'),
            'manage_options',
            'postybot-settings',
            array($this, 'render_admin_page')
        );
    }
    
    /**
     * Enqueue admin scripts and styles
     */
    public function enqueue_scripts($hook) {
        // Only load on PostyBot pages
        if (strpos($hook, 'postybot') === false) {
            return;
        }
        
        // Enqueue React and ReactDOM from WordPress
        wp_enqueue_script('react');
        wp_enqueue_script('react-dom');
        
        // Enqueue our React app
        wp_enqueue_script(
            'postybot-admin',
            PSTB_PLUGIN_URL . 'build/postybot-admin.js',
            array('react', 'react-dom'),
            PSTB_VERSION,
            true
        );
        
        // Localize script with data
        wp_localize_script('postybot-admin', 'pstbData', array(
            'apiUrl' => rest_url('postybot/v1'),
            'nonce' => PSTB_Security::create_nonce('wp_rest'),
            'adminUrl' => admin_url('admin.php?page=postybot'),
            'pluginUrl' => PSTB_PLUGIN_URL,
        ));
        
        // Enqueue WordPress components styles
        wp_enqueue_style('wp-components');
    }
    
    /**
     * Render admin page
     */
    public function render_admin_page() {
        ?>
        <div class="wrap">
            <div id="postybot-root"></div>
        </div>
        <?php
    }
}
