# PostyBot - The Ultimate Content Manager

![Version](https://img.shields.io/badge/version-1.0.0-blue.svg)
![WordPress](https://img.shields.io/badge/WordPress-6.0%2B-blue.svg)
![PHP](https://img.shields.io/badge/PHP-7.4%2B-purple.svg)
![License](https://img.shields.io/badge/license-GPL--2.0%2B-green.svg)

A powerful WordPress plugin that enables AI-powered content generation with a modern React-based admin interface. Generate high-quality blog posts, articles, tutorials, and more with just a few clicks.

## ✨ Features

- 🤖 **6 AI Providers** - Choose from Gemini, Hugging Face, Groq, Cerebras, OpenRouter, and OpenAI
- 🎨 **Modern React UI** - Beautiful, responsive interface with smooth animations
- 📝 **Smart Content Generation** - Automatic title, excerpt, categories, tags, and SEO meta
- 🖼️ **Featured Images** - Auto-fetch from Pexels, Unsplash, or Pixabay
- ⚡ **Bulk Generation** - Create multiple posts at once
- 📊 **Generation History** - Track all generated content with parameters
- 🔒 **Secure** - Encrypted API key storage and WordPress security best practices
- 🎯 **Customizable** - Control tone, length, format, audience, and more

## 🚀 Quick Start

### Installation

1. Clone or download this repository
2. Copy the `postybot` folder to `wp-content/plugins/`
3. Install dependencies and build:
   ```bash
   cd wp-content/plugins/postybot
   npm install
   npm run build
   ```
4. Activate the plugin in WordPress admin
5. Go to **PostyBot → Settings** to configure your AI provider

### Getting API Keys

**Free Options (Recommended for Testing):**
- [Google AI Studio (Gemini)](https://makersuite.google.com/app/apikey) - 1000 req/day
- [Hugging Face](https://huggingface.co/settings/tokens) - 300 req/hour
- [Groq](https://console.groq.com/) - Fast inference
- [Cerebras](https://cerebras.ai/) - High limits
- [OpenRouter](https://openrouter.ai/) - 50+ models

**Paid Option:**
- [OpenAI](https://platform.openai.com/api-keys) - GPT-3.5/GPT-4

**Image Providers (Optional):**
- [Pexels](https://www.pexels.com/api/) - Free
- [Unsplash](https://unsplash.com/developers) - Free
- [Pixabay](https://pixabay.com/api/docs/) - Free

## 📖 Usage

### 1. Configure Settings

Navigate to **PostyBot → Settings**:
- Select your preferred AI provider
- Enter API keys (encrypted automatically)
- Choose image provider
- Set default post status

### 2. Generate Content

Go to **PostyBot → Generate**:
- Enter a topic
- Use quick presets or customize parameters
- Click "Generate Content"
- Edit the generated post in Gutenberg

### 3. View History

Check **PostyBot → History** to see all generated content with full parameter details.

## 🏗️ Architecture

```
postybot/
├── postybot.php              # Main plugin file
├── includes/                 # PHP backend
│   ├── class-pstb-admin.php
│   ├── class-pstb-api.php
│   ├── class-pstb-security.php
│   ├── class-pstb-database.php
│   ├── class-pstb-content-generator.php
│   └── providers/            # AI provider implementations
├── src/                      # React frontend
│   ├── components/
│   ├── pages/
│   ├── hooks/
│   └── styles/
└── build/                    # Compiled assets
```

## 🛠️ Development

### Prerequisites

- Node.js 16+
- npm or yarn
- WordPress 6.0+
- PHP 7.4+

### Build Commands

```bash
# Install dependencies
npm install

# Development build with watch
npm run dev

# Production build
npm run build

# Type checking
npm run type-check
```

### Code Structure

- **PHP Classes**: Object-oriented, follows WordPress coding standards
- **React Components**: Functional components with TypeScript
- **Security**: Nonce verification, capability checks, input sanitization
- **Database**: Custom table for generation history

## 🔒 Security

- API keys encrypted with AES-256-CBC
- WordPress nonce verification on all requests
- Administrator-only access
- Input sanitization and validation
- Prepared SQL statements
- No external CDN dependencies

## 📝 WordPress.org Submission

This plugin is ready for WordPress.org submission:

✅ GPL v2+ licensed
✅ Proper plugin headers
✅ Security best practices
✅ Internationalization ready
✅ Clean uninstall process
✅ Comprehensive readme.txt

## 🤝 Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## 📄 License

This plugin is licensed under the GPL v2 or later.

```
PostyBot - The Ultimate Content Manager
Copyright (C) 2024

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
```

## 🙏 Credits

Built with:
- [React](https://react.dev/)
- [TypeScript](https://www.typescriptlang.org/)
- [Webpack](https://webpack.js.org/)
- [WordPress](https://wordpress.org/)

## 📧 Support

For issues and questions, please use the [GitHub Issues](https://github.com/notniloy/postybot/issues) page.

---

Made with ❤️ for the WordPress community
