<?php
/*
 * Plugin Name: PostTally
 * Plugin URI: https://wordpress.org/plugins/posttally/
 * Description: PostTally displays the total number of published posts using a shortcode (use [post_count] anywhere in your content).
 * Version: 1.0.0
 * Author: CaddyTzitzy
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: posttally
 */

/**
 * Prevent direct access to this file.
 */
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class to handle the PostTally functionality.
 */
class PostTally {

    /**
     * Constructor to initialize the plugin.
     */
    public function __construct() {
        // Register the shortcode
        add_action('init', array($this, 'register_shortcodes'));
    }

    /**
     * Register the [post_count] shortcode.
     */
    public function register_shortcodes() {
        add_shortcode('post_count', array($this, 'post_count_shortcode'));
    }

    /**
     * Shortcode callback to display the total number of published posts.
     *
     * @param array $atts Shortcode attributes (not used here).
     * @return string The total post count.
     */
    public function post_count_shortcode($atts) {
        // Get the count of published posts
        $post_count = wp_count_posts('post')->publish;

        // Sanitize and return the output
        return esc_html(number_format_i18n($post_count));
    }
}

/**
 * Instantiate the plugin class.
 */
new PostTally();