jQuery(document).ready(function($){
    let modal, mediaFrame;

    function ensureModal() {
        if (!modal) {
            const modalEl = document.getElementById('fqeModal');
            if (modalEl && window.bootstrap) {
                modal = new bootstrap.Modal(modalEl, {
                    backdrop: false,  // 🚫 no backdrop overlay
                    keyboard: true
                });
            } else if (modalEl) {
                // Fallback: simple show/hide
                modal = {
                    show: () => $(modalEl).show(),
                    hide: () => $(modalEl).hide()
                };
            }
        }
    }


    function initWpEditor() {
        if (typeof tinymce !== 'undefined' && tinymce.get('fqe-content')) {
            tinymce.get('fqe-content').remove();
        }
        if (typeof wp !== 'undefined' && wp.editor && wp.editor.initialize) {
            wp.editor.initialize('fqe-content', {
                tinymce: {
                    wpautop: true,
                    plugins: 'paste,lists,link,hr,wordpress,wpautoresize,wpgallery,wpdialogs,wptextpattern',
                    toolbar1: 'formatselect,bold,italic,bullist,numlist,link,undo,redo,removeformat',
                },
                quicktags: true,
                mediaButtons: false
            });
        }
    }

    function removeWpEditor() {
        if (typeof wp !== 'undefined' && wp.editor && wp.editor.remove) {
            try { wp.editor.remove('fqe-content'); } catch(e){}
        }
    }

    function getEditorContent() {
        if (typeof tinymce !== 'undefined' && tinymce.get('fqe-content')) {
            return tinymce.get('fqe-content').getContent();
        }
        return $('#fqe-content').val();
    }

    function setEditorContent(html) {
        if (typeof tinymce !== 'undefined' && tinymce.get('fqe-content')) {
            tinymce.get('fqe-content').setContent(html || '');
        } else {
            $('#fqe-content').val(html || '');
        }
    }

    function renderCustomFields(meta) {
        const keys = FQE_Ajax.custom_fields || [];
        let html = '';
        if (keys.length) {
            html += '<div class="card"><div class="card-header"><strong>Custom Fields</strong></div><div class="card-body">';
            keys.forEach(function(key){
                const val = (meta && typeof meta[key] !== 'undefined') ? meta[key] : '';
                const isLong = (val && String(val).length > 120);
                html += '<div class="mb-3">';
                html += '<label class="form-label">' + key + '</label>';
                if (isLong) {
                    html += '<textarea class="form-control fqe-meta-input" data-key="'+ key +'" rows="4">' + (val ? String(val) : '') + '</textarea>';
                } else {
                    html += '<input type="text" class="form-control fqe-meta-input" data-key="'+ key +'" value="' + (val ? String(val).replace(/"/g,'&quot;') : '') + '">';
                }
                html += '</div>';
            });
            html += '</div></div>';
        }
        $('#fqe-custom-fields').html(html);
    }

    function openMediaLibrary() {
        if (mediaFrame) {
            mediaFrame.open();
            return;
        }
        mediaFrame = wp.media({
            title: 'Insert Media',
            button: { text: 'Insert' },
            multiple: false
        });
        mediaFrame.on('select', function(){
            const attachment = mediaFrame.state().get('selection').first().toJSON();
            const imgHtml = '<img src="'+ attachment.url +'" alt="">';
            // Insert at cursor
            if (typeof tinymce !== 'undefined' && tinymce.get('fqe-content')) {
                tinymce.get('fqe-content').execCommand('mceInsertContent', false, imgHtml);
            } else {
                const $ta = $('#fqe-content');
                $ta.val(($ta.val() || '') + "\n" + imgHtml);
            }
        });
        mediaFrame.open();
    }

    $('.fqe-edit-btn').on('click', function(){
        ensureModal();
        if (!modal) return;

        const post_id = $(this).data('post-id');
        $('.fqe-status').text('Loading...');

        $.post(FQE_Ajax.ajax_url, {
            action: 'fqe_get_post',
            post_id: post_id,
            _ajax_nonce: FQE_Ajax.nonce
        }).done(function(res){
            if (res && res.success) {
                $('#fqe-title').val(res.data.title || '');
                setEditorContent(res.data.content || '');
                renderCustomFields(res.data.custom_meta || {});
                modal.show();
                setTimeout(function(){
                    initWpEditor();
                    $('.fqe-status').text('');
                }, 50);
            } else {
                alert((res && res.data && res.data.message) ? res.data.message : 'Failed to load post.');
            }
        }).fail(function(){
            alert('Error contacting server.');
        });
    });

    document.getElementById('fqeModal')?.addEventListener('hidden.bs.modal', function () {
        removeWpEditor();
        $('#fqe-content').val('');
        $('#fqe-title').val('');
        $('#fqe-custom-fields').empty();
        $('.fqe-status').text('');
    });

    $('#fqe-save').on('click', function(){
        const post_id = $(this).data('post-id');
        const title = $('#fqe-title').val();
        const content = getEditorContent();
        const custom_meta = {};

        $('.fqe-meta-input').each(function(){
            const key = $(this).data('key');
            custom_meta[key] = $(this).val();
        });

        $('.fqe-status').text('Saving...');

        $.post(FQE_Ajax.ajax_url, {
            action: 'fqe_save_post',
            post_id: post_id,
            title: title,
            content: content,
            custom_meta: custom_meta,
            _ajax_nonce: FQE_Ajax.nonce
        }).done(function(res){
            if (res && res.success) {
                $('.fqe-status').text('Saved.');
                if (res.data && res.data.title) {
                    const h1 = $('h1.entry-title, .entry-title').first();
                    if (h1.length) h1.text(res.data.title);
                }
                setTimeout(function(){
                    modal && modal.hide();
                    window.location.reload();
                }, 600);
            } else {
                alert((res && res.data && res.data.message) ? res.data.message : 'Failed to save post.');
                $('.fqe-status').text('');
            }
        }).fail(function(){
            alert('Error contacting server.');
            $('.fqe-status').text('');
        });
    });

    $('#fqe-insert-media').on('click', function(){
        openMediaLibrary();
    });
});
