<?php
use PTCM\Helpers;

defined( 'ABSPATH' ) || exit;

?>
<div id="ptcm-popup">
    <div class="ptcm-popup-inner">

        <!-- 👇 Sticky Header -->
        <div class="ptcm-popup-header">
            <h2>Edit Columns for <span id="ptcm-post-type-name">Post Type</span></h2>

            <div class="ptcm-header-actions">
                <button id="ptcm-reset-columns" class="pctm-primary-btn bg-light-blue">
                    <span class="dashicons dashicons-update"></span> Reset Columns
                </button>
                <span id="ptcm-popup-close">&times;</span>
            </div>
        </div>


        <!-- 👇 Main Content Area -->
        <div class="ptcm-popup-body">
            
            <div class="ptcm-columns-header">
                <span>
                    <div class="ptcm-toggle-wrap">
                        <input type="checkbox" id="ptcm-select-all" class="ptcm-enabled ptcm-checkbox ptcm-toggle" >
                        <label for="ptcm-select-all" class="ptcm-toggle-slider" title="Enable/Disable All Column"></label>
                    </div>
                 <span class="ptcm-help-icon dashicons dashicons-editor-help" data-tip="<?php echo esc_attr(Helpers::help_text('column_enabled')); ?>"></span></span>
                <span>Field Type <span class="ptcm-help-icon dashicons dashicons-editor-help" data-tip="<?php echo esc_attr(Helpers::help_text('column_type')); ?>"></span></span>
                <span>Label <span class="ptcm-help-icon dashicons dashicons-editor-help" data-tip="<?php echo esc_attr(Helpers::help_text('column_label')); ?>"></span></span>
                <span>Key <span class="ptcm-help-icon dashicons dashicons-editor-help" data-tip="<?php echo esc_attr(Helpers::help_text('column_key')); ?>"></span></span>
                <span>Hook <span class="ptcm-help-icon dashicons dashicons-editor-help" data-tip="<?php echo esc_attr(Helpers::help_text('column_hook')); ?>"></span></span>
                <span></span>
            </div>

            <div id="ptcm-columns-list" class="ptcm-columns-sortable"></div>

        </div>

        <!-- 👇 Sticky Footer -->
        <div class="ptcm-popup-footer">
            <button class="pctm-primary-btn pctm-p-all-13-17" id="ptcm-add-column">Add New Column</button>
            <button class="pctm-primary-bg-btn pctm-p-all-13-17" id="ptcm-save-columns">Save Columns</button>
        </div>

    </div>

    <div id="ptcm-popup-overlay">
        <div class="loader">
            <div class="ptcm-spinner"></div>
        </div>
    </div>

</div>

<div id="ptcm-hook-modal" >
  <div class="ptcm-hook-content">
    <span class="ptcm-close-icon">&times;</span>
    <h3>Filter Hook</h3>
    <p>Place this in your <code>functions.php</code> or a similar file, and <code>return</code> the output you need.</p>
    <p class="help">For more help: See the <code>HELP</code> section at the top right corner of the current page.</p>
    <pre><code id="ptcm-hook-code" class="language-php"></code></pre>
    <div class="ptcm-hook-footer">
      <button class="pctm-primary-btn" id="ptcm-copy-hook">Copy</button>
    </div>
  </div>
</div>






