<?php
namespace PTCM\Settings;

class TemplateHelpers {
    public static function get_active_tab(array $tabs): string {
        return isset($_GET['tab']) ? sanitize_key(wp_unslash($_GET['tab'])) : array_key_first($tabs); //phpcs:disable WordPress.Security.NonceVerification.Recommended
    }

    public static function is_settings_updated(): bool {
        return isset($_GET['settings-updated']) && sanitize_key(wp_unslash($_GET['settings-updated'])) === 'true'; //phpcs:disable WordPress.Security.NonceVerification.Recommended
    }
}
