<?php

namespace PTCM\Settings\Tabs;

use PTCM\TabInterface;
use PTCM\Main;
use PTCM\Core;

class Tab_General implements TabInterface
{

    public static bool $include = true;

    public static string $slug = 'general';

    public static string $title = 'General';

    public static function get_slug(): string
    {
        return self::$slug;
    }

    public static function get_title(): string
    {
        return self::$title;
    }

    public function render(): void
    {
        global $ptcm_settings, $has_ptcm_pro;

        $post_types = Core::get_filtered_post_types();
        $get_settings = Core::get_settings();
        $mod_saved_post_types = $get_settings[self::$slug]['post_types'] ?? [];
        $saved_post_types =  $has_ptcm_pro ? $mod_saved_post_types : array_diff($mod_saved_post_types, Core::$excluded_post_types);
        $tab_slug   = esc_attr(self::$slug);

?>

<form method="post" action="options.php" class="ptcm-settings-form">
        <?php 
            wp_nonce_field('ptcm_settings_save', 'ptcm_settings_nonce');
            
        ?>
        <input type="hidden" name="ptcm_tab_key" value="<?php echo esc_attr(self::$slug);?>">
        <?php settings_fields(Core::$group_key);?>

        <h2>Post Types</h2>
        <p class="ptcm-mb-14">Select the post types where the column editor should be active</p>

        <table class="wp-list-table widefat fixed striped ptcm-table-list">
            <thead>
                <tr >
                    <th style="width:65px; text-align:center;" class="heading"></th>
                    <th class="heading">Screen</th>
                    <th class="heading">Type</th>
                    <th class="heading">Status</th>
                    <th class="heading">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($post_types as $post_type): 
                    $is_pro_item = in_array($post_type->name, Core::$excluded_post_types);
                    $option_key = esc_attr(Core::$option_key);
                    $is_enabled = in_array($post_type->name, $saved_post_types) ;
                    $view_link = $is_pro_item && !$has_ptcm_pro ?  'javascript:;' : admin_url('edit.php?post_type='.$post_type->name);
                    $disable_row = $is_pro_item && !$has_ptcm_pro ? 'row-disabled' : '';
                    ?>
                    <tr class="<?php echo $disable_row;?>" >
                        <td>
                            <label class="ptcm-toggle-wrap">
                                <input 
                                    type="checkbox" 
                                    name="<?php echo esc_attr("{$option_key}[{$tab_slug}][post_types][]"); ?>" 
                                    value="<?php echo esc_attr($post_type->name) ?>" 
                                    <?php checked($is_enabled); ?> 
                                    <?php echo $is_pro_item && !$has_ptcm_pro ? 'disabled' : '' ?> >
                                <span class="ptcm-toggle-slider"></span>
                            </label>                            
                        </td>

                        <td class="column-primary">
                            <strong><?php echo esc_html($post_type->label) ?></strong>
                            <?php
                            if ($is_pro_item) {
                                $info_text = $has_ptcm_pro ? '<em style="color: #999;">Pro</em>' : '<em style="color: #999;"> (Pro Only)</em>';
                                echo apply_filters('ptcm_settings_post_type_info', $info_text, $post_type->name, $has_ptcm_pro); //phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped
                            }
                            ?>
                        </td>
                        <td> Post Type</td>
                        <td>
                            <?php if ($is_enabled): ?>
                                <span class="description" style="color:#036571;font-weight:500;">Enabled</span>
                            <?php else: ?>
                                <span class="description">Disabled</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <!-- <a href="#" class="ptcm-configure-link">Configure</a> |  -->
                            <a href="<?php echo $view_link;?>" class="ptcm-edit-link" target="_blank">View Screen</a>
                        </td>

                    </tr>
                <?php endforeach; ?>


            </tbody>
        </table>

        <?php
            submit_button(
                'Save Settings',     // $text
                'pctm-primary-btn', // $type (also used as class)
                'submit',            // $name
                true,                // $wrap (true = adds <p>)
                ['id' => 'ptcm-save-btn-'.$tab_slug] // $other_attributes
            );
            ?>
    </form>

<?php
    }
}
