<?php
namespace PTCM\Settings;
use PTCM\Settings\TemplateHelpers;
use PTCM\Settings\Notices;

class TabRenderer {

    public static function render(): void {
        $tabs = self::load_tabs();
        $active_tab = TemplateHelpers::get_active_tab($tabs);
        $settings_updated = TemplateHelpers::is_settings_updated();

        if (!apply_filters('ptcm_should_render_settings_page', true)) return;

        $wrapper_class = apply_filters('ptcm_wrapper_class', 'wrap ptcm-main ptcm-settings-wrapper');
        echo "<div class='" . esc_attr($wrapper_class) . "'>";

        do_action('ptcm_before_settings_page');

        Notices::render($settings_updated);

        do_action('ptcm_before_tabs_nav', $tabs, $active_tab);
        self::render_tab_nav($tabs, $active_tab);
        do_action('ptcm_after_tabs_nav', $tabs, $active_tab);

        self::render_tab_content($tabs, $active_tab);

        do_action('ptcm_after_settings_page');

        echo "</div>";
    }

    private static function load_tabs(): array {
        return apply_filters('ptcm_tabs', \PTCM\Settings\SettingsPage::load_tabs());
    }

    private static function render_tab_nav(array $tabs, string $active_tab): void {
        echo '<h2 class="' . esc_attr(apply_filters('ptcm_tab_wrapper_class', 'nav-tab-wrapper ptcm-tab-wrapper')) . '">';
        foreach ($tabs as $slug => $tab) {
            $classes = ['nav-tab'];
            if ($slug === $active_tab) {
                $classes[] = 'nav-tab-active';
            }

            $classes = apply_filters("ptcm_tab_classes_{$slug}", $classes);
            $label = $tab instanceof \PTCM\TabInterface ? $tab::get_title() : $tab;
            $label = apply_filters("ptcm_tab_label_{$slug}", $label);

            echo sprintf(
                '<a href="%s" class="%s">%s</a>',
                esc_url(add_query_arg(['tab' => $slug])),
                esc_attr(implode(' ', $classes)),
                esc_html($label)
            );
        }
        echo '</h2>';
    }

    private static function render_tab_content(array $tabs, string $active_tab): void {
        echo '<div class="' . esc_attr(apply_filters('ptcm_tab_content_class', 'ptcm-tab-content')) . '">';
        do_action("ptcm_before_tab_{$active_tab}");
        if (isset($tabs[$active_tab])) {
            $tab = $tabs[$active_tab];
            if ($tab instanceof \PTCM\TabInterface) {
                $tab->render();
            } else {
                do_action("ptcm_render_tab_{$active_tab}");
            }
        }
        do_action("ptcm_after_tab_{$active_tab}");
        echo '</div>';
    }
}
