<?php
namespace PTCM\Settings;

use PTCM\Settings\TabInterface;
use PTCM\Core;

class SettingsPage{

    public static function init() {
        add_action('admin_menu', [__CLASS__, 'add_settings_page']);
        add_action('admin_init', [ __CLASS__ , 'register_settings']);

    }

    public static $tabs = [];

    public static function add_settings_page() {
        add_menu_page(
            apply_filters('ptcm_admin_menu_label' , 'WP Admin Columns'),
            apply_filters('ptcm_admin_menu_label' , 'WP Admin Columns'),
            'manage_options',
            PTCM_SETTING_SLUG,
            [\PTCM\Settings\TabRenderer::class, 'render'],
            'dashicons-editor-table',
            30
        );      
    }

    public static function register_settings(): void {
        register_setting(
            Core::$group_key,
            Core::$option_key,
            array(
                'sanitize_callback' => [__CLASS__, 'sanitize_settings']
            )
        );        
    }

    public static function sanitize_deep($data) {
        if (is_array($data)) {
            $sanitized = [];
            foreach ($data as $key => $value) {
                $sanitized[sanitize_key($key)] = self::sanitize_deep($value);
            }
            return $sanitized;
        } else {
            return sanitize_text_field($data);
        }
    }
    
    

    public static function sanitize_settings($input) {

        global $has_ptcm_pro;

        $ptcm_settings_nonce = isset($_POST['ptcm_settings_nonce']) ? sanitize_text_field(wp_unslash($_POST['ptcm_settings_nonce'])) : '';

        if ( ! $ptcm_settings_nonce || ! wp_verify_nonce( $ptcm_settings_nonce , 'ptcm_settings_save') ) {
            wp_die('Security check failed. Please try again.');
        }
      
        $existing = get_option(Core::$option_key, []);
    
        // Detect current tab from request, assuming form submits this hidden field
        $current_tab = isset($_POST['ptcm_tab_key']) ? sanitize_key(wp_unslash($_POST['ptcm_tab_key'])) : '';

        self::load_tabs();
    
        $cleaned = [];


        if (isset(self::$tabs[$current_tab])) {
            $tab = self::$tabs[$current_tab];
        
            if ($tab instanceof \PTCM\TabInterface) {
                
                if ($current_tab === 'general' && isset($input[$current_tab]['post_types']) && !$has_ptcm_pro ) {
                    // Remove strict post types
                    $input[$current_tab]['post_types'] = array_diff(
                        $input[$current_tab]['post_types'],
                        Core::strict_post_types()
                    );
                }

                $cleaned[$current_tab] = self::sanitize_deep($input[$current_tab] ?? []);
                $output = $existing ? array_merge($existing, $cleaned) : $cleaned;
            } else {
                // Let external devs handle their own save
                do_action("ptcm_save_tab_{$current_tab}", $input[$current_tab] ?? []);
                $output = $existing;
            }
        }

        //print_r($output);die;

        return $output;
    }
    
    
    public static function load_tabs(): array {
        // Load core tabs from Free plugin
        self::load_tab_classes_from(__DIR__ . '/Tabs', 'PTCM\\Settings\\Tabs');
    
        /**
         * Allow other plugins (like Pro) to register tab folders.
         * Each item should be an array with:
         * - 'path'      => folder path
         * - 'namespace' => namespace of the Tab_*.php files
         */
        $external_folders = apply_filters('ptcm_tab_folders', []);
    
        foreach ($external_folders as $folder) {
            if (!empty($folder['path']) && !empty($folder['namespace']) && is_dir($folder['path'])) {
                self::load_tab_classes_from($folder['path'], $folder['namespace']);
            }
        }
    
        // Optional hook-based tab registration
        $external_tabs = apply_filters('ptcm_register_tabs', []);
        foreach ($external_tabs as $slug => $title) {
            self::$tabs[$slug] = $title;
        }
    
        return self::$tabs;
    }

    private static function load_tab_classes_from(string $dir, string $namespace): void {
        foreach (glob($dir . '/Tab_*.php') as $file) {
            require_once $file;
            $base = basename($file, '.php');
            $class_name = $namespace . '\\' . $base;
    
            if (class_exists($class_name)) {
                $instance = new $class_name();
                if ($instance instanceof \PTCM\TabInterface && $class_name::$include === true) {
                    self::$tabs[$class_name::get_slug()] = $instance;
                }
            }
        }
    }
    
    
    
    
}


