<?php
namespace PTCM;
use PTCM\Settings\SettingsPage;

class Core {

    public static string $group_key = 'ptcm_settings_group';
    public static string $option_key = 'ptcm_core_settings';
    public static array $settings_data = [];
    public static string $native_column_option_prefix = 'ptcm_native_column_';
    public static string $post_type_custom_fields_prefix = 'ptcm_custom_fields_';

    public static function get_settings_tab_slugs(){
        $tabs = SettingsPage::load_tabs();
        if($tabs){
            return array_keys($tabs);
        }
        return [];
    }


    public static function get_settings(): array {
        $settings = get_option(self::$option_key, []);
        return $settings ? $settings : [] ; 
    }

    public static array $excluded_post_types = array(
        'product',
        'shop_order',
        'shop_coupon'
    );

    public static function strict_post_types():array{
        return apply_filters( 'ptcm_strict_post_types', self::$excluded_post_types );
    }

    public static function default_data(): array {
        return array(
            'general' => array(
                'post_types' => array(
                    'post',
                    'page'
                ),
            )
        );
    }

    public static function set_default_options(): void {
        $get_settings = Core::get_settings();
        if(!$get_settings){
            update_option(
                self::$option_key,
                self::default_data()
            );
        } 
    }

    public static function reset_options(): void {
        delete_option(self::$option_key);
    }

    public static function get_saved_post_types(): array {
        $get_settings = Core::get_settings();
        return $get_settings['general']['post_types'] ?? [];
    }

    public static function is_enabled_for_post_type(string $post_type): bool {
        if( in_array($post_type, self::strict_post_types() ) ){
            return false;
        }else if( in_array($post_type, self::get_saved_post_types()) ){
            return true;
        }else{
            return false;
        }  
    }

    public static function get_filtered_post_types(): array {
        $post_types = get_post_types(['show_ui' => true], 'objects');
    
        if (!$post_types) {
            return [];
        }
    
        $filtered_post_types = [];
    
        foreach ($post_types as $post_type => $obj) {
            // Skip if no menu or no list UI
            if (
                $post_type === 'attachment' ||
                !$obj->show_in_menu ||
                !$obj->show_ui ||
                !post_type_supports($post_type, 'title') || // heuristic: listing usually needs title
                !isset($obj->cap->edit_posts) ||
                !current_user_can($obj->cap->edit_posts)
            ) {
                continue;
            }
  
            $filtered_post_types[$post_type] = $obj;

        }
        return $filtered_post_types;
    }
    

}