<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://profiles.wordpress.org/dipankarpal212
 * @since             1.0.0
 * @package           ptcm
 *
 * @wordpress-plugin
 * Plugin Name:       WP Admin Columns
 * Requires at least: 5.8
 * Requires PHP:      7.4
 * Description:       Customize WordPress admin columns for post types, users, taxonomies & more. Add, reorder, or remove columns easily – no coding needed.
 * Version:           1.0.5
 * Author:            Dipankar Pal
 * Author URI:        https://profiles.wordpress.org/dipankarpal212
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       post-type-column-editor
 * Domain Path:       /languages
 * Playground: true
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

require_once plugin_dir_path(__FILE__) . 'includes/class-loader.php';

define( 'PTCM_PATH',  plugin_dir_path( __FILE__ ) );
define( 'PTCM_URL',  plugin_dir_url( __FILE__ ) );
define( 'PTCM_BASE',  plugin_basename(__FILE__) );


add_action('plugins_loaded', function () {
    global $has_ptcm_pro;
    $has_ptcm_pro = class_exists( 'PTCMPro\\Core\\Init' );
	\PTCM\Plugin::get_instance();
});


require_once plugin_dir_path(__FILE__) . 'vendor/autoload.php';

if (!function_exists('ptcm')) {
    function ptcm(): \PTCM\Plugin {
        return \PTCM\Plugin::get_instance();
    }
}

function ptcm_activate_plugin() {
	\PTCM\Activator::activate();	
}

function ptcm_deactivate_plugin() {
	\PTCM\Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'ptcm_activate_plugin' );
register_deactivation_hook( __FILE__, 'ptcm_deactivate_plugin' );

if ( ! function_exists( 'ptcm_register_template_override_dir' ) ) {
    function ptcm_register_template_override_dir( $dir ) {
        global $ptcm_template_override_dirs;

        if ( ! isset( $ptcm_template_override_dirs ) || ! is_array( $ptcm_template_override_dirs ) ) {
            $ptcm_template_override_dirs = [];
        }

        if ( is_dir( $dir ) ) {
            $ptcm_template_override_dirs[] = trailingslashit( $dir );
        }
    }
}

