<?php
namespace PTCM;

use PTCM\TemplateLoader;
use PTCM\Get_Columns;
use PTCM\HelpTab;

class UI_Controller {

    public static function enqueue_assets(): void {
        global $ptcm_screen_data;
        $screen        = get_current_screen();   
        $screen_data = self::get_screen_type($screen);
        $ptcm_screen_data = $screen_data;
        
        $do_render_btn = Plugin::maybe_render_manage_button( $screen_data ,$screen);

        do_action('ptcm_global_before_enqueue' , $screen );

        if('toplevel_page_'.PTCM_SETTING_SLUG == $screen->base ){
            // Always‑needed settings page CSS:
            do_action('ptcm_settings_before_enqueue' , $screen );
            Assets::style( 'plugin-settings.css' );
            do_action('ptcm_settings_after_enqueue' , $screen );
        }
    
        
        // Only for edit screens / popup logic:
        if ( $do_render_btn ) {

            do_action('ptcm_current_screen' , $screen_data , $screen );// trigger the popup UI  
    
            do_action('ptcm_screen_before_enqueue' , $screen );

            // Core admin JS
            Assets::style( 'main.css' );
            wp_enqueue_script( 'jquery' );
            Assets::script( 'select2.min.js', [ 'jquery' ] );
            Assets::style( 'select2.min.css' );

            $column_map = Get_Columns::map_all_columns($screen_data);
            
            // Plugin utility bundle
            Assets::script( 'plugins/ptcm-utils.js', [ 'jquery' ] );
    
            wp_add_inline_script(
                Assets::make_handle( 'plugins/ptcm-utils.js' ),
                'window.ptcmData = ' . wp_json_encode( [
                    'debug'     => true,
                    'nonce'     => wp_create_nonce( 'ptcm_nonce' ),
                    'col_types' => Helpers::get_source_dropdown_options($screen_data, 'Column' ), //suffix Column
                    'sources'   => Helpers::get_source_dropdown_options($screen_data), // suffix Field
                    'fields'    => $column_map,
                    'post_type' => $screen->post_type,
                    'ajax_url'      => admin_url( 'admin-ajax.php' ),
                    'screen_data' => $screen_data
                ] ),
                'before'
            );
    
            // Other plugin scripts (dependencies handled automatically)
            Assets::script( 'plugins/jquery.ptcmTooltip.js',      [ 'jquery' ] );
            Assets::script( 'plugins/jquery.ptcmRenderRow.js',    [ 'jquery' ] );
            Assets::script( 'plugins/jquery.ptcmColumnManager.js',[ 'jquery' ] );
            Assets::script(
                'main.js',
                [
                    'jquery',
                    Assets::make_handle( 'plugins/jquery.ptcmTooltip.js' ),
                    Assets::make_handle( 'plugins/jquery.ptcmRenderRow.js' ),
                    Assets::make_handle( 'plugins/jquery.ptcmColumnManager.js' ),
                ]
            );
   
            wp_localize_script(
                Assets::make_handle( 'main.js' ),
                'PTCM',
                [
                    'ajax_url'          => admin_url( 'admin-ajax.php' ),
                    'post_type'         => $screen->post_type,
                    'nonce'             => wp_create_nonce( 'ptcm_nonce' ),
                    'do_render_btn'     => $do_render_btn,
                    'screen'            => $screen_data,
                    'screen_type'       => $screen_data['type'],
                    'screen_label'      => Helpers::get_screen_label( $screen_data ),
                    'screen_id'         => $screen_data['id'],
                    'screen_base'       => $screen_data['base'],
                    'screen_context'    => [
                        'post_type' => $screen_data['post_type'] ?? '',
                        'taxonomy'  => $screen_data['taxonomy'] ?? '',
                    ]
                ]
            );

            do_action('ptcm_screen_after_enqueue' , $screen );
        }

        do_action('ptcm_global_after_enqueue' , $screen );
    }

    public static function get_screen_type( $screen ): array {
    
        // Only allow 'post' screen in free version
        if ( $screen->base === 'edit' && ! empty( $screen->post_type ) ) {
            return [
                'type'       => 'post',
                'base'       => $screen->base,
                'id'         => $screen->id,
                'post_type'  => $screen->post_type ?? '',
                'taxonomy'   => $screen->taxonomy ?? '',
            ];
        } 

        $screen_data = [
            'type'       => '',
            'base'       => $screen->base,
            'id'         => $screen->id,
            'post_type'  => $screen->post_type ?? '',
            'taxonomy'   => $screen->taxonomy ?? '',
        ];
    
        return apply_filters( 'ptcm_get_screen_type', $screen_data , $screen);
    }
    
    
    

    public static function render_popup(): void {        
        TemplateLoader::load_template( 'popup-settings.php' );
    }
}
