<?php
namespace PTCM;

class Save_Columns {

    public static function init(): void {}

    public static function save_columns() {
        check_ajax_referer('ptcm_nonce', 'nonce');
    
        $screen_type    = isset($_POST['screen_type']) ?  sanitize_text_field(wp_unslash($_POST['screen_type'])) : 'post';
        $screen_context = isset($_POST['screen_context']) ? $_POST['screen_context'] : []; //phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized,WordPress.Security.ValidatedSanitizedInput.MissingUnslash	
        $columns = isset($_POST['columns']) ? $_POST['columns'] : []; //phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized,WordPress.Security.ValidatedSanitizedInput.MissingUnslash	
    
        if (!is_array($columns) || empty($screen_type)) {
            wp_send_json_error(['message' => 'Invalid or missing data.']);
        }
    
        
        $handled = apply_filters('ptcm_handle_save_columns_for_screen_type', null, $screen_type, $screen_context, $columns);
    
        if ($handled === true) {
            wp_send_json_success(['message' => 'Saved successfully']);
        } 
    
        if ($screen_type !== 'post') {
            wp_send_json_error(['message' => 'Screen type not supported.']);
        }
    
        $post_type = sanitize_text_field($screen_context['post_type'] ?? '');
    
        if (!$post_type) {
            wp_send_json_error(['message' => 'Missing post type.']);
        }

        $screen_context['type'] =  $screen_type ;
    
        $non_editable_columns_array = Helpers::non_editable_columns_array($screen_context);
        $sanitized = [];
    
        foreach ($columns as $col) {
            $key     = sanitize_key($col['key'] ?? '');
            $label   = sanitize_text_field($col['label'] ?? '');
            $col_label = $col['col_label'] ?? '';
            $source  = sanitize_text_field($col['source'] ?? '');
            $enabled = !empty($col['enabled']);
    
            if (!$key || !$label || !$source) continue;
    
            $label_enabled  = true;
            $key_enabled = false;
            $key_enabled    = !in_array($source, $non_editable_columns_array);
    
            $enabled = $key === 'title' ? true : $enabled;
    
            $entry = [
                'key'            => $key,
                'label'          => $label,
                'col_label'      => $col_label,
                'source'         => $source,
                'enabled'        => $enabled,
                'label_enabled'  => $label_enabled,
                'key_enabled'    => $key_enabled,
            ];
    
            $sanitized[] = $entry;
        }
    
        update_option(PTCM_DATA_ColSettings . '--' . $screen_type . '--' . $post_type, $sanitized);
    
        wp_send_json_success(['message' => 'Saved successfully']);
    }
    
    
    
}
